/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.jdbc;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.jdbc.RowIterator;
import org.ujorm.tools.msg.SimpleValuePrinter;
import org.ujorm.tools.set.LoopingIterator;

public final class JdbcBuilder
implements Serializable {
    protected static final char ITEM_SEPARATOR = ',';
    protected static final char VALUE_MARKER = '?';
    protected static final char SPACE = ' ';
    @Nonnull
    protected final StringBuilder sql;
    protected final List<Object> arguments = new ArrayList<Object>();
    protected boolean emptySql = true;
    protected int columnCounter = 0;
    protected int conditionCounter = 0;
    protected boolean insertMode = false;

    public JdbcBuilder() {
        this(new StringBuilder(32));
    }

    public JdbcBuilder(@Nonnull StringBuilder sql) {
        this.sql = sql;
    }

    @Nonnull
    public JdbcBuilder concat(@Nonnull JdbcBuilder builder) {
        this.sql.append(builder.getSql());
        this.arguments.add(builder.arguments);
        this.columnCounter += builder.columnCounter;
        this.conditionCounter += builder.conditionCounter;
        this.emptySql = false;
        return this;
    }

    @Nonnull
    public JdbcBuilder write(@Nonnull CharSequence sqlFragment) {
        if (this.emptySql) {
            this.emptySql = false;
        } else {
            this.sql.append(' ');
        }
        this.sql.append(sqlFragment);
        return this;
    }

    @Nonnull
    public JdbcBuilder rawWrite(@Nonnull CharSequence sqlFragment) {
        if (this.emptySql) {
            this.emptySql = false;
        }
        this.sql.append(sqlFragment);
        return this;
    }

    @Nonnull
    public JdbcBuilder column(@Nonnull CharSequence column) {
        if (this.columnCounter++ > 0) {
            this.sql.append(',');
        }
        this.sql.append(' ');
        this.sql.append(column);
        return this;
    }

    @Nonnull
    public JdbcBuilder columnUpdate(@Nonnull CharSequence column, @Nonnull Object value) {
        Assert.validState(!this.insertMode, "The insertion mode has been started.");
        if (!this.arguments.isEmpty()) {
            this.sql.append(',');
        }
        this.sql.append(' ').append(column).append(' ').append('=').append(' ').append('?');
        this.arguments.add(value);
        return this;
    }

    @Nonnull
    public JdbcBuilder columnInsert(@Nonnull CharSequence column, @Nonnull Object value) {
        this.insertMode = true;
        if (!this.arguments.isEmpty()) {
            this.sql.append(',');
        }
        this.sql.append(' ').append(column);
        this.arguments.add(value);
        return this;
    }

    @Nonnull
    public JdbcBuilder value(@Nonnull Object param) {
        if (!this.arguments.isEmpty()) {
            this.sql.append(',');
        }
        this.sql.append(' ');
        this.sql.append('?');
        this.arguments.add(param);
        return this;
    }

    @Nonnull
    public JdbcBuilder andCondition(@Nonnull CharSequence sqlCondition, @Nullable Object value) {
        return this.andCondition(sqlCondition, null, value);
    }

    @Nonnull
    public JdbcBuilder andCondition(@Nonnull CharSequence sqlCondition, @Nullable String operator, @Nullable Object value) {
        return this.condition(sqlCondition, operator, value, true);
    }

    @Nonnull
    public JdbcBuilder orCondition(@Nonnull CharSequence sqlCondition, @Nullable Object value) {
        return this.orCondition(sqlCondition, null, value);
    }

    @Nonnull
    public JdbcBuilder orCondition(@Nonnull CharSequence sqlCondition, @Nullable String operator, @Nullable Object value) {
        return this.condition(sqlCondition, operator, value, false);
    }

    @Nonnull
    public JdbcBuilder condition(@Nonnull CharSequence sqlCondition, @Nullable Object value, @Nullable Boolean andOperator) {
        return this.condition(sqlCondition, null, value, andOperator);
    }

    @Nonnull
    public JdbcBuilder condition(@Nonnull CharSequence sqlCondition, @Nullable String operator, @Nullable Object value, @Nullable Boolean andOperator) {
        if (Check.hasLength(sqlCondition)) {
            if (this.conditionCounter++ > 0 && andOperator != null) {
                this.sql.append(andOperator != false ? " AND " : " OR ");
            } else {
                this.sql.append(' ');
            }
            this.sql.append(sqlCondition);
            if (Check.hasLength(operator)) {
                this.sql.append(' ');
                this.sql.append(operator);
                this.sql.append(' ');
                this.sql.append('?');
            }
            this.arguments.add(value);
        }
        return this;
    }

    @Nonnull
    public Object[] getArguments() {
        return this.arguments.toArray(new Object[this.arguments.size()]);
    }

    @Nonnull
    public JdbcBuilder rawArguments(Object ... values) {
        Object[] vals = values.length == 1 && values[0] instanceof Object[] ? (Object[])values[0] : values;
        for (int i = 0; i < vals.length; ++i) {
            this.arguments.add(values[i]);
        }
        return this;
    }

    @Nonnull
    public PreparedStatement prepareStatement(@Nonnull Connection connection) throws SQLException {
        PreparedStatement result = connection.prepareStatement(this.getSql());
        int max = this.arguments.size();
        for (int i = 0; i < max; ++i) {
            result.setObject(i + 1, this.arguments.get(i));
        }
        return result;
    }

    public LoopingIterator<ResultSet> executeSelect(@Nonnull Connection connection) throws IllegalStateException, SQLException {
        return new RowIterator(this.prepareStatement(connection));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(@Nonnull Connection connection) throws IllegalStateException {
        try (PreparedStatement ps = this.prepareStatement(connection);){
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(this.getSql(), e);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T uniqueValue(@Nonnull Class<T> resultType, @Nonnull Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public String getSql() {
        if (this.insertMode) {
            String valuesBeg = " VALUES (";
            String valuesEnd = " )";
            StringBuilder result = new StringBuilder(this.sql.length() + " VALUES (".length() + this.arguments.size() * 3 + " )".length());
            result.append((CharSequence)this.sql);
            result.append(" VALUES (");
            int max = this.arguments.size();
            for (int i = 0; i < max; ++i) {
                result.append(i > 0 ? "," : "").append(' ').append('?');
            }
            result.append(" )");
            return result.toString();
        }
        return this.sql.toString();
    }

    @Nonnull
    public String toString() {
        return new SimpleValuePrinter(String.valueOf('?'), "'", new CharArrayWriter(64)).formatMsg(this.getSql(), this.getArguments());
    }
}

