/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.dom.Element;

public class XmlElement
implements Element {
    public static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    @Nonnull
    protected final CharSequence name;
    @Nullable
    private Map<String, Object> attributes;
    @Nullable
    private List<Object> children;

    public XmlElement(@Nonnull CharSequence name) {
        this.name = name;
    }

    public XmlElement(@Nonnull CharSequence name, @Nonnull XmlElement parent) {
        this(name);
        parent.getChildren().add(this);
    }

    @Nonnull
    protected Map<String, Object> getAttribs() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        return this.attributes;
    }

    @Nonnull
    protected List<Object> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Object>();
        }
        return this.children;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addElement(@Nonnull T element) {
        Assert.notNull(element, "element");
        this.getChildren().add(element);
        return element;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addElement(@Nonnull CharSequence name) {
        Assert.hasLength(name, "Undefined element name");
        return (T)new XmlElement(name, this);
    }

    @Override
    @Nonnull
    public final <T extends Element> T addAttrib(@Nonnull CharSequence name, @Nullable Object value) {
        Assert.hasLength(name, "name");
        if (value != null) {
            this.getAttribs().put(name.toString(), value);
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addText(@Nullable CharSequence text) {
        if (Check.hasLength(text)) {
            this.getChildren().add(text);
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addTextWithSpace(@Nullable CharSequence text) {
        if (Check.hasLength(text)) {
            this.getChildren().add(Character.valueOf(' '));
            this.getChildren().add(text);
            this.getChildren().add(Character.valueOf(' '));
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addRawText(@Nullable CharSequence rawText) {
        if (Check.hasLength(rawText)) {
            this.getChildren().add(new RawEnvelope(rawText));
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addComment(@Nullable CharSequence comment) {
        if (Check.hasLength(comment)) {
            Assert.isTrue(!comment.toString().contains("-->"), "The text contains a forbidden string: -->");
            StringBuilder msg = new StringBuilder("<!--".length() + "-->".length() + comment.length() + 2);
            this.addRawText(msg.append("<!--").append(' ').append(comment).append(' ').append("-->"));
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends Element> T addCDATA(@Nullable CharSequence charData) {
        if (Check.hasLength(charData)) {
            int j;
            this.addRawText("<![CDATA[");
            String text = charData.toString();
            int i = 0;
            while ((j = text.indexOf("]]>", i)) >= 0) {
                this.addRawText(text.subSequence(i, j += "]]>".length()));
                i = j;
                this.addText("]]>");
                this.addRawText("<![CDATA[");
            }
            this.addRawText(i == 0 ? text : text.substring(i));
            this.addRawText("]]>");
        }
        return (T)this;
    }

    protected void writeValue(@Nonnull Object value, boolean attribute, @Nonnull Writer out) throws IOException {
        CharSequence text = value instanceof CharSequence ? (CharSequence)value : String.valueOf(value);
        int max = text.length();
        block7: for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    out.append('&').append("lt;");
                    continue block7;
                }
                case '>': {
                    out.append('&').append("gt;");
                    continue block7;
                }
                case '&': {
                    out.append('&').append("#38;");
                    continue block7;
                }
                case '\'': {
                    out.append('&').append("#39;");
                    continue block7;
                }
                case '\"': {
                    out.append('&').append("#34;");
                    continue block7;
                }
                default: {
                    if (c > ' ' || c == ' ') {
                        out.append(c);
                        continue block7;
                    }
                    out.append('&').append("#");
                    out.append(Integer.toString(c));
                    out.append(";");
                }
            }
        }
    }

    @Nonnull
    public String toString() {
        try {
            return this.toWriter(new CharArrayWriter(512).append(HEADER).append('\n')).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @Nonnull
    public Writer toWriter(@Nonnull Writer out) throws IOException {
        out.append('<');
        out.append(this.name);
        if (Check.hasLength(this.attributes)) {
            for (String key : this.attributes.keySet()) {
                out.append(' ');
                out.append(key);
                out.append('=');
                out.append('\"');
                this.writeValue(this.attributes.get(key), true, out);
                out.append('\"');
            }
        }
        if (Check.hasLength(this.children)) {
            out.append('>');
            boolean writeNewLine = true;
            for (Object child : this.children) {
                if (child instanceof XmlElement) {
                    if (writeNewLine) {
                        out.append('\n');
                    } else {
                        writeNewLine = true;
                    }
                    ((XmlElement)child).toWriter(out);
                    continue;
                }
                if (child instanceof RawEnvelope) {
                    out.append(((RawEnvelope)child).get());
                    writeNewLine = false;
                    continue;
                }
                this.writeValue(child, false, out);
                writeNewLine = false;
            }
            out.append('<');
            out.append('/');
            out.append(this.name);
        } else {
            out.append('/');
        }
        out.append('>');
        return out;
    }

    protected static final class RawEnvelope {
        private final CharSequence body;

        public RawEnvelope(@Nonnull CharSequence body) {
            this.body = body;
        }

        @Nonnull
        public CharSequence get() {
            return this.body;
        }
    }
}

