/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.jdbc;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.set.LoopingIterator;

public class RowIterator
implements LoopingIterator<ResultSet> {
    @Nonnull
    private final PreparedStatement ps;
    @Nullable
    private ResultSet rs;
    private boolean cursorReady = false;
    private boolean hasNext = false;

    public RowIterator(@Nonnull PreparedStatement ps) {
        this.ps = ps;
    }

    public RowIterator iterator() {
        return this;
    }

    @Override
    public boolean hasNext() throws IllegalStateException {
        if (!this.cursorReady) {
            try {
                if (this.rs == null) {
                    this.rs = this.ps.executeQuery();
                }
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                this.cursorReady = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.hasNext;
    }

    @Override
    public ResultSet next() {
        if (this.hasNext()) {
            this.cursorReady = false;
            return this.rs;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws IOException {
        if (this.rs != null) {
            try (PreparedStatement tempPs = this.ps;
                 ResultSet tempRs = this.rs;){
                this.cursorReady = true;
                this.hasNext = false;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

