/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.CharArrayWriter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.msg.ValueFormatter;

public class ValuePrinter
extends ValueFormatter {
    protected final CharArrayWriter out;

    public ValuePrinter(int size) {
        this(new CharArrayWriter(size));
    }

    public ValuePrinter(@Nonnull CharArrayWriter out) {
        this("?", "\"", out);
    }

    public ValuePrinter(@Nonnull String mark, @Nonnull String textBorder, @Nonnull CharArrayWriter out) {
        super(mark, textBorder);
        this.out = out;
    }

    @Nonnull
    public ValuePrinter appendValue(@Nullable Object value) {
        if (value instanceof Object[]) {
            boolean first = true;
            for (Object object : (Object[])value) {
                if (first) {
                    first = !first;
                } else {
                    this.out.append(", ");
                }
                this.appendValue(object);
            }
        } else {
            super.writeValue(value, this.out, true);
        }
        return this;
    }

    public CharArrayWriter getWriter() {
        return this.out;
    }

    @Nonnull
    public String toString() {
        return this.out.toString();
    }
}

