/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.dom.XmlWriter;

public class XmlElement {
    public static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";
    @Nonnull
    protected final CharSequence name;
    @Nullable
    protected Map<String, Object> attributes;
    @Nullable
    protected List<Object> children;

    public XmlElement(@Nonnull CharSequence name) {
        this.name = name;
    }

    public XmlElement(@Nonnull CharSequence name, @Nonnull XmlElement parent) {
        this(name);
        parent.addChild(this);
    }

    @Nonnull
    protected Map<String, Object> getAttribs() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        return this.attributes;
    }

    @Nonnull
    protected void addChild(@Nonnull Object child) {
        if (this.children == null) {
            this.children = new ArrayList<Object>();
        }
        this.children.add(child);
    }

    @Nonnull
    public final <T extends XmlElement> T addElement(@Nonnull T element) {
        Assert.notNull(element, "element");
        this.addChild(element);
        return element;
    }

    @Nonnull
    public final <T extends XmlElement> T addElement(@Nonnull CharSequence name) {
        Assert.hasLength(name, "Undefined element name");
        return (T)new XmlElement(name, this);
    }

    @Nonnull
    public final <T extends XmlElement> T addAttrib(@Nonnull CharSequence name, @Nullable Object value) {
        Assert.hasLength(name, "name");
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(name.toString(), value);
        }
        return (T)this;
    }

    @Nonnull
    public final <T extends XmlElement> T addText(@Nullable CharSequence text) {
        if (Check.hasLength(text)) {
            this.addChild(text);
        }
        return (T)this;
    }

    @Nonnull
    public final <T extends XmlElement> T addTextWithSpace(@Nullable CharSequence text) {
        if (Check.hasLength(text)) {
            this.addChild(Character.valueOf(' '));
            this.addChild(text);
            this.addChild(Character.valueOf(' '));
        }
        return (T)this;
    }

    @Nonnull
    public final <T extends XmlElement> T addRawText(@Nullable CharSequence rawText) {
        if (Check.hasLength(rawText)) {
            this.addChild(new RawEnvelope(rawText));
        }
        return (T)this;
    }

    @Nonnull
    public final <T extends XmlElement> T addComment(@Nullable CharSequence comment) {
        if (Check.hasLength(comment)) {
            Assert.isTrue(!comment.toString().contains("-->"), "The text contains a forbidden string: -->");
            StringBuilder msg = new StringBuilder("<!--".length() + "-->".length() + comment.length() + 2);
            this.addRawText(msg.append("<!--").append(' ').append(comment).append(' ').append("-->"));
        }
        return (T)this;
    }

    @Nonnull
    public final <T extends XmlElement> T addCDATA(@Nullable CharSequence charData) {
        if (Check.hasLength(charData)) {
            int j;
            this.addRawText("<![CDATA[");
            String text = charData.toString();
            int i = 0;
            while ((j = text.indexOf("]]>", i)) >= 0) {
                this.addRawText(text.subSequence(i, j += "]]>".length()));
                i = j;
                this.addText("]]>");
                this.addRawText("<![CDATA[");
            }
            this.addRawText(i == 0 ? text : text.substring(i));
            this.addRawText("]]>");
        }
        return (T)this;
    }

    @Nonnull
    public String getName() {
        return this.name.toString();
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap();
    }

    @Nonnull
    public List<Object> getChildren() {
        return this.children != null ? Collections.unmodifiableList(this.children) : Collections.emptyList();
    }

    @Nonnull
    public String toString() {
        try {
            return this.toWriter(0, new XmlWriter(new CharArrayWriter(512).append(HEADER).append('\n'))).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public XmlWriter toWriter(int level, @Nonnull XmlWriter out) throws IOException {
        return out.write(level, this);
    }

    protected static final class RawEnvelope {
        private final CharSequence body;

        public RawEnvelope(@Nonnull CharSequence body) {
            this.body = body;
        }

        @Nonnull
        public CharSequence get() {
            return this.body;
        }
    }
}

