/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.dom.XmlElement;

public class XmlWriter {
    public static final char XML_GT = '>';
    public static final char XML_LT = '<';
    public static final char XML_AMP = '&';
    public static final char XML_QUOT = '\'';
    public static final char XML_2QUOT = '\"';
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_NEW_LINE = '\n';
    public static final char FORWARD_SLASH = '/';
    public static final String CDATA_BEG = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String COMMENT_BEG = "<!--";
    public static final String COMMENT_END = "-->";
    @Nonnull
    protected final Writer out;
    protected final boolean offsetEnabled;
    @Nullable
    protected final String offsetSpace;

    public XmlWriter() {
        this(new CharArrayWriter(512));
    }

    public XmlWriter(@Nonnull Writer out) {
        this(out, "");
    }

    public XmlWriter(@Nonnull Writer out, @Nullable String offsetSpace) {
        this.out = out;
        this.offsetEnabled = Check.hasLength(offsetSpace);
        this.offsetSpace = offsetSpace;
    }

    @Nonnull
    public XmlWriter write(int level, @Nonnull XmlElement element) throws IOException {
        return this.write(level, element.name, element.attributes, element.children, element);
    }

    @Nonnull
    protected XmlWriter write(int level, @Nonnull CharSequence name, @Nullable Map<String, Object> attributes, @Nullable List<Object> children, @Nonnull XmlElement element) throws IOException {
        this.out.append('<');
        this.out.append(name);
        if (Check.hasLength(attributes)) {
            assert (attributes != null);
            for (String key : attributes.keySet()) {
                this.out.append(' ');
                this.out.append(key);
                this.out.append('=');
                this.out.append('\"');
                this.writeValue(attributes.get(key), element, key, this.out);
                this.out.append('\"');
            }
        }
        if (Check.hasLength(children)) {
            assert (children != null);
            this.out.append('>');
            boolean writeNewLine = true;
            for (Object child : children) {
                if (child instanceof XmlElement) {
                    if (writeNewLine) {
                        this.newLine(level);
                    } else {
                        writeNewLine = true;
                    }
                    this.write(level + 1, (XmlElement)child);
                    continue;
                }
                if (child instanceof XmlElement.RawEnvelope) {
                    this.out.append(((XmlElement.RawEnvelope)child).get());
                    writeNewLine = false;
                    continue;
                }
                this.writeValue(child, element, null, this.out);
                writeNewLine = false;
            }
            this.out.append('<');
            this.out.append('/');
            this.out.append(name);
        } else {
            this.out.append('/');
        }
        this.out.append('>');
        return this;
    }

    protected void newLine(int level) throws IOException {
        this.out.append('\n');
        if (this.offsetEnabled) {
            for (int i = level - 1; i >= 0; --i) {
                this.out.append(this.offsetSpace);
            }
        }
    }

    protected void writeValue(@Nonnull Object value, @Nonnull XmlElement element, @Nullable String attribute, @Nonnull Writer out) throws IOException {
        CharSequence text = value instanceof CharSequence ? (CharSequence)value : String.valueOf(value);
        int max = text.length();
        block7: for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    out.append('&').append("lt;");
                    continue block7;
                }
                case '>': {
                    out.append('&').append("gt;");
                    continue block7;
                }
                case '&': {
                    out.append('&').append("#38;");
                    continue block7;
                }
                case '\'': {
                    out.append('&').append("#39;");
                    continue block7;
                }
                case '\"': {
                    out.append('&').append("#34;");
                    continue block7;
                }
                default: {
                    if (c > ' ' || c == ' ') {
                        out.append(c);
                        continue block7;
                    }
                    out.append('&').append("#");
                    out.append(Integer.toString(c));
                    out.append(";");
                }
            }
        }
    }

    @Nonnull
    public String toString() {
        String result = this.out.toString();
        return result != null ? result : String.valueOf(result);
    }
}

