/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

public abstract class Assert {
    public static final Object[] NO_MESSAGE = null;

    private Assert() {
    }

    public static final <T> void validState(boolean condition, T ... message) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static final void isTrue(boolean condition) throws IllegalArgumentException {
        Assert.isTrue(condition, NO_MESSAGE);
    }

    public static final <T> void isTrue(boolean condition, T ... message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <T, M> void isTrue(@Nullable T condition, @Nonnull Predicate<T> predicate, M ... message) {
        if (condition == null || !predicate.test(condition)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T, M> void isTrueNullable(@Nullable T value, @Nonnull Predicate<T> predicate, M ... message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void notNull(@Nullable Object value) throws IllegalArgumentException {
        Assert.notNull(value, NO_MESSAGE);
    }

    public static <T> void notNull(@Nullable Object value, T ... message) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <T> void hasLength(@Nullable byte[] array, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void hasLength(@Nullable char[] array, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void hasLength(@Nullable Object[] values, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void hasLength(@Nullable Collection<?> values, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void hasLength(@Nullable Map<?, ?> values, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void hasLength(@Nullable CharSequence value, T ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void isFalse(boolean condition) throws IllegalArgumentException {
        Assert.isFalse(condition, NO_MESSAGE);
    }

    public static final void isFalse(boolean condition, Object ... message) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <T, M> void isFalse(@Nullable T value, @Nonnull Predicate<T> predicate, M ... message) {
        if (value == null || predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T, M> void isFalseNullable(@Nullable T value, @Nonnull Predicate<T> predicate, M ... message) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void isNull(@Nullable Object value) throws IllegalArgumentException {
        Assert.isNull(value, NO_MESSAGE);
    }

    public static <T> void isNull(@Nullable Object value, T ... message) throws IllegalArgumentException {
        if (value != null) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(byte[] array, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(@Nullable char[] array, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(@Nullable Object[] values, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(@Nullable Collection<?> values, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(@Nullable Map<?, ?> values, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <T> void isEmpty(@Nullable CharSequence value, T ... message) throws IllegalArgumentException {
        if (Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }
}

