/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;

public abstract class AbstractElement<E extends AbstractElement>
implements Closeable {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String HTML_DOCTYPE = "<!DOCTYPE html>";
    public static final String DEFAULT_INTENDATION = "    ";
    protected static final String REQUIRED_MSG = "The argument {} is required";
    @Nonnull
    protected final String name;

    public AbstractElement(@Nonnull CharSequence name) {
        Assert.notNull(name, REQUIRED_MSG, "name");
        this.name = name.toString();
    }

    @Nonnull
    public final String getName() {
        return this.name;
    }

    @Nonnull
    public abstract <T extends E> T addElement(@Nonnull String var1) throws IOException;

    @Nonnull
    public abstract <T extends E> T setAttrib(@Nonnull String var1, @Nullable Object var2) throws IOException;

    @Nonnull
    public abstract <T extends E> T addText(@Nullable Object var1) throws IOException;

    @Nonnull
    public abstract <T extends E> T addRawText(@Nullable Object var1) throws IOException;

    @Nonnull
    public abstract <T extends E> T addComment(@Nullable CharSequence var1) throws IOException;

    @Nonnull
    public abstract <T extends E> T addCDATA(@Nullable CharSequence var1) throws IOException;
}

