/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.builder;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.xml.CommonXmlWriter;
import org.ujorm.tools.xml.builder.XmlBuilder;

public class XmlPrinter
extends CommonXmlWriter {
    public XmlPrinter() {
        this(new CharArrayWriter(512));
    }

    public XmlPrinter(@Nonnull Appendable out) {
        this(out, "", new Object[0]);
    }

    public <T> XmlPrinter(@Nonnull Appendable out, @Nullable String indentationSpace, T ... prefix) {
        super(out, indentationSpace);
        try {
            for (T text : prefix) {
                out.append(String.valueOf(text));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeRawValue(@Nonnull Object rawValue, @Nonnull XmlBuilder element) throws IOException {
        this.out.append(rawValue.toString());
    }

    void writeAttrib(String name, Object data, XmlBuilder owner) throws IOException {
        this.out.append(' ');
        this.out.append(name);
        this.out.append('=');
        this.out.append('\"');
        this.writeValue(data, owner, name);
        this.out.append('\"');
    }

    void writeRawText(Object rawText) throws IOException {
        this.out.append(String.valueOf(rawText));
    }

    void writeBeg(XmlBuilder element, boolean lastText) throws IOException {
        if (!lastText) {
            this.writeNewLine(element.getLevel());
        }
        this.out.append('<');
        this.out.append(element.getName());
    }

    void writeMid(XmlBuilder element) throws IOException {
        this.out.append('>');
    }

    void writeEnd(XmlBuilder element) throws IOException {
        if (element.isFilled()) {
            if (this.indentationEnabled && !element.isLastText()) {
                this.writeNewLine(element.getLevel());
            }
            this.out.append('<');
            this.out.append('/');
            this.out.append(element.getName());
            this.out.append('>');
        } else {
            this.out.append('/');
            this.out.append('>');
        }
    }

    @Override
    @Nonnull
    public String toString() {
        String result = this.out.toString();
        return result != null ? result : String.valueOf(result);
    }

    public XmlBuilder createHtmlElement() throws IOException {
        return this.createElement("html");
    }

    public XmlBuilder createElement(@Nonnull String elementName) throws IOException {
        return new XmlBuilder(elementName, this);
    }

    public static XmlPrinter forXml() {
        return new XmlPrinter(new StringBuilder(512), null, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public static XmlPrinter forXml(boolean indentation) {
        return new XmlPrinter(new StringBuilder(512), indentation ? "    " : null, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    public static XmlPrinter forHtml() {
        return new XmlPrinter(new StringBuilder(512), null, "<!DOCTYPE html>");
    }

    public static XmlPrinter forHtml(Appendable out) {
        return new XmlPrinter(out, null, "<!DOCTYPE html>");
    }

    public static XmlPrinter forNiceHtml(Appendable out) {
        return new XmlPrinter(out, "    ", "<!DOCTYPE html>");
    }

    public static XmlPrinter forHtml(@Nonnull Object httpServletResponse) throws IOException {
        return XmlPrinter.forHtml(httpServletResponse, StandardCharsets.UTF_8, null, false);
    }

    public static XmlPrinter forNiceHtml(@Nonnull Object httpServletResponse) throws IOException {
        return XmlPrinter.forHtml(httpServletResponse, StandardCharsets.UTF_8, "    ", false);
    }

    public static XmlPrinter forHtml(@Nonnull Object httpServletResponse, @Nonnull Charset charset, String indentationSpace, boolean noCache) throws IOException {
        try {
            Writer writer = XmlPrinter.createWriter(httpServletResponse, charset, noCache);
            return new XmlPrinter(writer, indentationSpace, "<!DOCTYPE html>");
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Response must be type of HttpServletResponse", e);
        }
    }
}

