/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.dom;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.CommonXmlWriter;
import org.ujorm.tools.xml.dom.XmlElement;
import org.ujorm.tools.xml.dom.XmlWriter;

public class HtmlElement
extends XmlElement {
    @Nonnull
    private final XmlElement head;
    @Nonnull
    private final XmlElement body;
    @Nonnull
    protected final Charset charset;

    public HtmlElement(@Nonnull Charset charset) {
        super("html");
        Assert.notNull(charset, "The argument {} is required", "charset");
        this.charset = charset;
        this.head = this.addElement("head");
        this.body = this.addElement("body");
    }

    public HtmlElement(@Nonnull Object title, CharSequence ... cssLinks) {
        this(title, StandardCharsets.UTF_8, cssLinks);
    }

    public HtmlElement(@Nonnull Object title, @Nonnull Charset charset, CharSequence ... cssLinks) {
        this(charset);
        ((XmlElement)this.head.addElement("meta")).setAttrib("charset", charset);
        ((XmlElement)this.head.addElement("title")).addText(title);
        if (cssLinks != null) {
            for (CharSequence cssLink : cssLinks) {
                this.addCssLink(cssLink);
            }
        }
    }

    @Nonnull
    @Deprecated
    public <T extends XmlElement> T getHead() {
        return (T)this.head;
    }

    @Nonnull
    public <T extends XmlElement> T getBody() {
        return (T)this.body;
    }

    public <T extends XmlElement> T addElementToHead(@Nonnull String name) {
        return (T)this.head.addElement(name);
    }

    public <T extends XmlElement> T addElementToBody(@Nonnull String name) {
        return (T)this.body.addElement(name);
    }

    public <T extends XmlElement> T addJavascriptLink(boolean defer, CharSequence ... javascriptLink) {
        Assert.notNull(javascriptLink, "The argument {} is required", "javascriptLink");
        return (T)((XmlElement)((XmlElement)((XmlElement)((XmlElement)this.head.addElement("script")).setAttrib("src", javascriptLink)).setAttrib("type", "text/javascript")).setAttrib("defer", defer ? "defer" : null)).addText("");
    }

    public <T extends XmlElement> T addJavascriptContent(@Nonnull CharSequence javascript) {
        Assert.notNull(javascript, "The argument {} is required", "javascript");
        return (T)((XmlElement)((XmlElement)((XmlElement)this.head.addElement("script")).setAttrib("language", "javascript")).setAttrib("type", "text/javascript")).addText(javascript);
    }

    public <T extends XmlElement> T addCssLink(@Nonnull CharSequence css) {
        Assert.notNull(css, "The argument {} is required", "css");
        return (T)((XmlElement)((XmlElement)((XmlElement)this.head.addElement("link")).setAttrib("href", css)).setAttrib("rel", "stylesheet")).setAttrib("type", "text/css");
    }

    public <T extends XmlElement> T addCssBody(@Nonnull CharSequence css) {
        Assert.notNull(css, "The argument {} is required", "css");
        return (T)((XmlElement)((XmlElement)this.head.addElement("style")).setAttrib("type", "text/css")).addRawText(css);
    }

    @Override
    @Nonnull
    public String toString() throws IllegalStateException {
        try {
            return this.toWriter(0, new XmlWriter(new StringBuilder(512).append("<!DOCTYPE html>").append('\n'))).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void toResponse(@Nonnull Object httpServletResponse, boolean noCache) throws IOException, IllegalArgumentException {
        this.toResponse(httpServletResponse, noCache, false);
    }

    public final void toNiceResponse(@Nonnull Object httpServletResponse) throws IOException, IllegalArgumentException {
        this.toResponse(httpServletResponse, true, true);
    }

    public void toResponse(@Nonnull Object httpServletResponse, boolean noCache, boolean indentation) throws IOException, IllegalArgumentException {
        try {
            Writer writer = CommonXmlWriter.createWriter(httpServletResponse, this.charset, noCache);
            String offset = indentation ? "    " : null;
            this.toWriter(new XmlWriter(writer.append("<!DOCTYPE html>").append('\n'), offset));
            writer.flush();
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Response must be type of HttpServletResponse", e);
        }
    }

    public XmlWriter toWriter(@Nonnull XmlWriter xmlWriter) throws IOException, IllegalArgumentException {
        return this.toWriter(0, xmlWriter);
    }

    public static interface Html {
        public static final String HTML = "html";
        public static final String HEAD = "head";
        public static final String META = "meta";
        public static final String BODY = "body";
        public static final String TITLE = "title";
        public static final String LINK = "link";
        public static final String STYLE = "style";
        public static final String SCRIPT = "script";
        public static final String A_CHARSET = "charset";
        public static final String A_HREF = "href";
        public static final String A_REL = "rel";
        public static final String A_TYPE = "type";
        public static final String A_SRC = "src";
        public static final String A_LANGUAGE = "language";
    }
}

