/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

public abstract class Assert {
    public static final Object[] NO_MESSAGE = null;

    private Assert() {
    }

    public static final <M> void validState(boolean condition, M ... message) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(MsgFormatter.format(message));
        }
    }

    @Nonnull
    public static <V, M> V notNullState(@Nullable V value, M ... message) throws IllegalStateException {
        if (value == null) {
            throw new IllegalStateException(MsgFormatter.format(message), new NullPointerException());
        }
        return value;
    }

    public static final void isTrue(boolean condition) throws IllegalArgumentException {
        Assert.isTrue(condition, NO_MESSAGE);
    }

    public static final <M> void isTrue(boolean condition, M ... message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <V, M> void isTrue(@Nullable V condition, @Nonnull Predicate<V> predicate, M ... message) {
        if (condition == null || !predicate.test(condition)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <V, M> void isTrueNullable(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    @Nonnull
    public static <V, M> Optional<V> isPresented(@Nullable V value, M ... message) throws IllegalArgumentException {
        return Optional.of(Assert.notNull(value, message));
    }

    @Nonnull
    public static final <V> V notNull(@Nullable V value) throws IllegalArgumentException {
        return Assert.notNull(value, NO_MESSAGE);
    }

    @Nonnull
    public static <V, M> V notNull(@Nullable V value, M ... message) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
        return value;
    }

    @Nonnull
    public static <M> byte[] hasLength(@Nullable byte[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <M> char[] hasLength(@Nullable char[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <M> Object[] hasLength(@Nullable Object[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <V, M> Collection<V> hasLength(@Nullable Collection<V> value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    @Nonnull
    public static <K, V, M> Map<K, V> hasLength(@Nullable Map<K, V> value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    @Nonnull
    public static <M> CharSequence hasLength(@Nullable CharSequence value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    public static final void isFalse(boolean condition) throws IllegalArgumentException {
        Assert.isFalse(condition, NO_MESSAGE);
    }

    public static final void isFalse(boolean condition, Object ... message) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
    }

    public static <V, M> void isFalse(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (value == null || predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <V, M> void isFalseNullable(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final void isNull(@Nullable Object value) throws IllegalArgumentException {
        Assert.isNull(value, NO_MESSAGE);
    }

    public static <M> void isNull(@Nullable Object value, M ... message) throws IllegalArgumentException {
        if (value != null) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(byte[] array, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable char[] array, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable Object[] values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable Collection<?> values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable Map<?, ?> values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable CharSequence value, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }
}

