/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.dom;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.CommonXmlWriter;
import org.ujorm.tools.xml.dom.XmlElement;

public class XmlWriter
extends CommonXmlWriter {
    public XmlWriter() {
        this(new CharArrayWriter(512));
    }

    public XmlWriter(@Nonnull Appendable out) {
        this(out, "");
    }

    public XmlWriter(@Nonnull Appendable out, @Nullable String indentationSpace) {
        super(out, indentationSpace);
    }

    @Nonnull
    public final XmlWriter write(int level, @Nonnull XmlElement element) throws IOException {
        return this.write(level, element.getName(), element.attributes, element.children, element);
    }

    @Nonnull
    protected XmlWriter write(int level, @Nonnull CharSequence name, @Nullable Map<String, Object> attributes, @Nullable List<Object> children, @Nonnull XmlElement element) throws IOException {
        this.out.append('<');
        this.out.append(name);
        if (Check.hasLength(attributes)) {
            assert (attributes != null);
            for (String key : attributes.keySet()) {
                this.out.append(' ');
                this.out.append(key);
                this.out.append('=');
                this.out.append('\"');
                this.writeValue(attributes.get(key), element, key);
                this.out.append('\"');
            }
        }
        if (Check.hasLength(children)) {
            assert (children != null);
            this.out.append('>');
            boolean writeNewLine = true;
            for (Object child : children) {
                if (child instanceof XmlElement) {
                    if (writeNewLine) {
                        this.writeNewLine(level);
                    } else {
                        writeNewLine = true;
                    }
                    this.write(level + 1, (XmlElement)child);
                    continue;
                }
                if (child instanceof XmlElement.RawEnvelope) {
                    this.writeRawValue(((XmlElement.RawEnvelope)child).get(), element);
                    writeNewLine = false;
                    continue;
                }
                this.writeValue(child, element, null);
                writeNewLine = false;
            }
            if (this.indentationEnabled && writeNewLine) {
                this.writeNewLine(level - 1);
            }
            this.out.append('<');
            this.out.append('/');
            this.out.append(name);
        } else {
            this.out.append('/');
        }
        this.out.append('>');
        return this;
    }
}

