/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.AbstractElement;

public abstract class AbstractWriter {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String HTML_DOCTYPE = "<!DOCTYPE html>";
    public static final char XML_GT = '>';
    public static final char XML_LT = '<';
    public static final char XML_AMPERSAND = '&';
    public static final char XML_APOSTROPHE = '\'';
    public static final char XML_2QUOT = '\"';
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_NEW_LINE = '\n';
    public static final char FORWARD_SLASH = '/';
    public static final String CDATA_BEG = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String COMMENT_BEG = "<!--";
    public static final String COMMENT_END = "-->";
    @Nonnull
    protected final Appendable out;
    @Nonnull
    protected final String indentationSpace;
    protected final boolean indentationEnabled;

    public AbstractWriter(@Nonnull Appendable out, @Nullable String indentationSpace) {
        this.out = Assert.notNull(out, "out");
        this.indentationSpace = indentationSpace;
        this.indentationEnabled = Check.hasLength(indentationSpace);
    }

    public void write(@Nonnull CharSequence text, boolean attribute) throws IOException {
        int max = text.length();
        block7: for (int i = 0; i < max; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    this.out.append('&').append("lt;");
                    continue block7;
                }
                case '>': {
                    this.out.append('&').append("gt;");
                    continue block7;
                }
                case '&': {
                    this.out.append('&').append("amp;");
                    continue block7;
                }
                case '\"': {
                    if (attribute) {
                        this.out.append('&').append("quot;");
                        continue block7;
                    }
                    this.out.append(c);
                    continue block7;
                }
                case '\'': {
                    this.out.append(c);
                    continue block7;
                }
                default: {
                    if (c > ' ' || c == ' ') {
                        this.out.append(c);
                        continue block7;
                    }
                    this.out.append('&').append("#");
                    this.out.append(Integer.toString(c));
                    this.out.append(";");
                }
            }
        }
    }

    public void writeValue(@Nullable Object value, @Nonnull AbstractElement element, @Nullable String attribute) throws IOException {
        CharSequence text = value instanceof CharSequence ? (CharSequence)value : String.valueOf(value);
        this.write(text, attribute != null);
    }

    public void writeRawValue(@Nonnull Object rawValue, @Nonnull AbstractElement element) throws IOException {
        this.out.append(rawValue.toString());
    }

    public void writeNewLine(int level) throws IOException {
        this.out.append('\n');
        if (this.indentationEnabled) {
            for (int i = level; i > 0; --i) {
                this.out.append(this.indentationSpace);
            }
        }
    }

    public String toString() {
        return this.out.toString();
    }

    public static Writer createWriter(@Nonnull Object httpServletResponse, @Nonnull Charset charset, boolean noCache) throws ReflectiveOperationException {
        Method setEncoding = httpServletResponse.getClass().getMethod("setCharacterEncoding", String.class);
        Method setHeader = httpServletResponse.getClass().getMethod("setHeader", String.class, String.class);
        Method getWriter = httpServletResponse.getClass().getMethod("getWriter", new Class[0]);
        setEncoding.invoke(httpServletResponse, charset.toString());
        setHeader.invoke(httpServletResponse, "Content-Type", "text/html; charset=" + charset);
        if (noCache) {
            setHeader.invoke(httpServletResponse, "Cache-Control", "no-cache, no-store, must-revalidate");
            setHeader.invoke(httpServletResponse, "Pragma", "no-cache");
            setHeader.invoke(httpServletResponse, "Expires", "0");
            setHeader.invoke(httpServletResponse, "X-UA-Compatible", "IE=edge");
        }
        Writer writer = (Writer)getWriter.invoke(httpServletResponse, new Object[0]);
        return writer;
    }
}

