/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class DefaultHtmlConfig
extends DefaultXmlConfig
implements HtmlConfig {
    @Nonnull
    private CharSequence title = "Demo";
    @Nonnull
    private CharSequence[] cssLinks = new CharSequence[0];
    @Nonnull
    private CharSequence language = "en";
    @Nonnull
    private Map<String, Map<String, Object>> headers;

    @Override
    @Nonnull
    public String getDoctype() {
        return this.nonnull(this.doctype, "<!DOCTYPE html>");
    }

    @Override
    @Nonnull
    public CharSequence getTitle() {
        return this.title;
    }

    @Override
    public CharSequence[] getCssLinks() {
        return this.cssLinks;
    }

    @Override
    public Optional<CharSequence> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    @Override
    public Map<String, Map<String, Object>> getHeaders() {
        return this.headers;
    }

    public void setTitle(@Nonnull CharSequence title) {
        this.title = Assert.hasLength(title, "title");
    }

    public void setCssLinks(CharSequence ... cssLinks) {
        this.cssLinks = Assert.hasLength(cssLinks, new String[]{"The argument {} is required", "cssLinks"});
    }

    public void setLanguage(@Nonnull CharSequence language) {
        this.language = language;
    }

    public void setHeaders(Map<String, Map<String, Object>> headers) {
        this.headers = headers;
    }
}

