/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;

public abstract class Assert {
    private Assert() {
    }

    public static <M> void state(boolean condition, M ... message) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(MsgFormatter.format(message));
        }
    }

    public static <M> void state(boolean condition, @Nonnull MessageMaker messageMaker) throws IllegalStateException {
        if (!condition) {
            throw new IllegalStateException(MessageBuilder.get(messageMaker));
        }
    }

    @Deprecated
    public static <M> void validState(boolean condition, M ... message) throws IllegalStateException {
        Assert.state(condition, message);
    }

    @Nonnull
    public static <V, M> V notNullState(@Nullable V value, M ... message) throws IllegalStateException {
        if (value == null) {
            throw new IllegalStateException(MsgFormatter.format(message), new NullPointerException());
        }
        return value;
    }

    public static <M> void isTrue(boolean condition, M ... message) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isTrue(boolean condition, @Nonnull MessageMaker messageMaker) throws IllegalArgumentException {
        if (!condition) {
            throw new IllegalArgumentException(MessageBuilder.get(messageMaker));
        }
    }

    public static <V, M> void isTrueRequired(@Nullable V condition, @Nonnull Predicate<V> predicate, M ... message) {
        if (condition == null || !predicate.test(condition)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <V, M> void isTrue(@Nullable V condition, @Nonnull Predicate<V> predicate, @Nonnull MessageMaker messageMaker) {
        if (!predicate.test(condition)) {
            throw new IllegalArgumentException(MessageBuilder.get(messageMaker));
        }
    }

    public static <V, M> void isTrue(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (!predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    @Nonnull
    public static <V, M> Optional<V> isPresented(@Nullable V value, M ... message) throws IllegalArgumentException {
        return Optional.of(Assert.notNull(value, message));
    }

    @Nonnull
    public static <V, M> V notNull(@Nullable V value, M ... message) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(MsgFormatter.format(message), new NullPointerException());
        }
        return value;
    }

    @Nonnull
    public static <M> byte[] hasLength(@Nullable byte[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <M> char[] hasLength(@Nullable char[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <V, M> V[] hasLength(@Nullable V[] array, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (array != null);
        return array;
    }

    @Nonnull
    public static <V, M> Collection<V> hasLength(@Nullable Collection<V> value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    @Nonnull
    public static <V, K, M> Map<K, V> hasLength(@Nullable Map<K, V> value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    @Nonnull
    public static <V extends CharSequence, M> V hasLength(@Nullable V value, M ... message) throws IllegalArgumentException {
        if (!Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
        assert (value != null);
        return value;
    }

    public static void isFalse(boolean condition, Object ... message) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static void isFalse(boolean condition, @Nonnull MessageMaker messageMaker) throws IllegalArgumentException {
        if (condition) {
            throw new IllegalArgumentException(MessageBuilder.get(messageMaker));
        }
    }

    public static <V, M> void isFalseRequired(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (value == null || predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <V, M> void isFalse(@Nullable V value, @Nonnull Predicate<V> predicate, @Nonnull MessageMaker messageMaker) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(MessageBuilder.get(messageMaker));
        }
    }

    public static <V, M> void isFalse(@Nullable V value, @Nonnull Predicate<V> predicate, M ... message) {
        if (predicate.test(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isNull(@Nullable Object value, M ... message) throws IllegalArgumentException {
        if (value != null) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(byte[] array, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable char[] array, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(array)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <V, M> void isEmpty(@Nullable V[] values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable Collection<?> values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable Map<?, ?> values, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(values)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static <M> void isEmpty(@Nullable CharSequence value, M ... message) throws IllegalArgumentException {
        if (Check.hasLength(value)) {
            throw new IllegalArgumentException(MsgFormatter.format(message));
        }
    }

    public static final class MessageBuilder {
        private String msg;

        public <T> void format(@Nullable Object messageTemplate, T ... arguments) {
            this.msg = MsgFormatter.format(String.valueOf(messageTemplate), arguments);
        }

        public <T> void sformat(@Nullable Object messageTemplate, T ... arguments) {
            this.msg = Check.hasLength(arguments) ? String.format(Locale.ENGLISH, String.valueOf(messageTemplate), (Object[])arguments) : String.valueOf(messageTemplate);
        }

        public static String get(@Nonnull MessageMaker messageMaker) {
            MessageBuilder content = new MessageBuilder();
            messageMaker.write(content);
            return content.msg;
        }
    }

    public static interface MessageMaker {
        public void write(MessageBuilder var1);
    }
}

