/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.jdbc.JdbcFunction;
import org.ujorm.tools.jdbc.ProxySequence;
import org.ujorm.tools.jdbc.RowIterator;
import org.ujorm.tools.msg.ValuePrinter;
import org.ujorm.tools.set.LoopingIterator;

public class JdbcBuilder
implements Serializable {
    public static final SqlEnvelope ITEM_SEPARATOR = new SqlEnvelope(",");
    protected static final String VALUE_MARKER = "?";
    protected static final char SPACE = ' ';
    @Nonnull
    protected final List<CharSequence> sql;
    @Nonnull
    protected final List<Object> arguments;
    protected int conditionCounter = 0;
    protected int columnCounter = 0;
    protected boolean insertMode = false;

    public JdbcBuilder() {
        this(new ArrayList<CharSequence>(32), new ArrayList<Object>());
    }

    public JdbcBuilder(@Nonnull List<CharSequence> sql, @Nonnull List<Object> arguments) {
        this.sql = sql;
        this.arguments = arguments;
    }

    @Nonnull
    public JdbcBuilder write(@Nonnull JdbcBuilder builder) {
        this.sql.addAll(builder.sql);
        this.arguments.addAll(builder.arguments);
        return this;
    }

    @Nonnull
    public JdbcBuilder write(@Nullable CharSequence sqlFragment) {
        if (Check.hasLength(sqlFragment)) {
            this.sql.add(sqlFragment);
        }
        return this;
    }

    @Nonnull
    public JdbcBuilder writeNoSpace(@Nonnull CharSequence sqlFragment) {
        if (Check.hasLength(sqlFragment)) {
            this.sql.add(new SqlEnvelope(sqlFragment));
        }
        return this;
    }

    @Nonnull
    public JdbcBuilder writeMany(CharSequence ... sqlFragments) {
        for (CharSequence text : sqlFragments) {
            this.write(text);
        }
        return this;
    }

    @Nonnull
    public JdbcBuilder writeManyNoSpace(CharSequence ... sqlFragments) {
        for (CharSequence text : sqlFragments) {
            this.writeNoSpace(text);
        }
        return this;
    }

    @Nonnull
    public JdbcBuilder column(@Nonnull CharSequence column) {
        this.sql.add(new SqlEnvelope(column, this.columnCounter++));
        return this;
    }

    @Nonnull
    public JdbcBuilder columnUpdate(@Nonnull CharSequence column, @Nonnull Object value) {
        Assert.state(!this.insertMode, "An insertion mode has been started.");
        this.sql.add(new SqlEnvelope(column, this.columnCounter++));
        this.sql.add("=");
        this.addValue(value);
        return this;
    }

    @Nonnull
    public JdbcBuilder columnInsert(@Nonnull CharSequence column, @Nonnull Object value) {
        this.insertMode = true;
        this.sql.add(new SqlEnvelope(column, this.columnCounter++));
        this.arguments.add(value);
        return this;
    }

    @Nonnull
    public JdbcBuilder andCondition(@Nonnull CharSequence sqlCondition, @Nullable String operator, @Nullable Object value) {
        this.writeOperator(true, this.conditionCounter++ > 0);
        return this.condition(sqlCondition, operator, value);
    }

    @Nonnull
    public JdbcBuilder andCondition(@Nonnull CharSequence sqlCondition, @Nonnull String operator, Object ... values) {
        this.writeOperator(true, this.conditionCounter++ > 0);
        return Check.hasLength(values) ? this.condition(sqlCondition, operator, values) : this.condition(sqlCondition, operator, null);
    }

    @Nonnull
    public JdbcBuilder orCondition(@Nonnull CharSequence sqlCondition, @Nullable String operator, @Nullable Object value) {
        this.writeOperator(false, this.conditionCounter++ > 0);
        return this.condition(sqlCondition, operator, value);
    }

    @Nonnull
    public JdbcBuilder orCondition(@Nonnull CharSequence sqlCondition, @Nonnull String operator, Object ... values) {
        this.writeOperator(false, this.conditionCounter++ > 0);
        return Check.hasLength(values) ? this.condition(sqlCondition, operator, values) : this.condition(sqlCondition, operator, null);
    }

    @Nonnull
    public JdbcBuilder condition(@Nullable CharSequence sqlCondition, @Nullable String operator, @Nonnull Object value) {
        if (Check.hasLength(sqlCondition)) {
            Object[] objectArray;
            boolean multiValue = value instanceof Object[];
            if (multiValue) {
                objectArray = (Object[])value;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = value;
            }
            Object[] values = objectArray;
            if (Check.hasLength(operator)) {
                this.sql.add(sqlCondition);
                this.sql.add(operator);
                if (multiValue) {
                    this.sql.add("(");
                }
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        this.sql.add(ITEM_SEPARATOR);
                    }
                    this.addValue(values[i]);
                }
                if (multiValue) {
                    this.sql.add(")");
                }
            } else {
                this.writeNoSpace(String.valueOf(' '));
                String cond = String.valueOf(sqlCondition);
                for (Object val : values) {
                    int i = cond.indexOf(VALUE_MARKER);
                    if (i >= 0) {
                        int i2 = i - (i > 0 && cond.charAt(i - 1) == ' ' ? 1 : 0);
                        this.writeNoSpace(cond.subSequence(0, i2));
                        this.addValue(val);
                    } else {
                        this.sql.add(cond);
                    }
                    cond = cond.substring(i + VALUE_MARKER.length());
                }
                this.writeNoSpace(cond);
            }
        }
        return this;
    }

    protected void writeOperator(@Nullable boolean andOperator, boolean enabled) {
        if (enabled) {
            this.sql.add(andOperator ? "AND" : "OR");
        }
    }

    @Nonnull
    public JdbcBuilder value(@Nonnull Object value) {
        if (value != null && !this.arguments.isEmpty()) {
            this.sql.add(ITEM_SEPARATOR);
        }
        return this.addValue(value);
    }

    @Nonnull
    protected JdbcBuilder addValue(@Nullable Object value) {
        if (value != null) {
            this.sql.add(new MarkerEnvelope(value));
            this.arguments.add(value);
        }
        return this;
    }

    @Nonnull
    public JdbcBuilder addArguments(Object ... values) {
        Object[] vals = values.length == 1 && values[0] instanceof Object[] ? (Object[])values[0] : values;
        for (int i = 0; i < vals.length; ++i) {
            this.arguments.add(values[i]);
        }
        return this;
    }

    @Nonnull
    public Object[] getArguments() {
        return this.arguments.toArray(new Object[this.arguments.size()]);
    }

    @Nonnull
    public PreparedStatement prepareStatement(@Nonnull Connection connection) throws SQLException {
        PreparedStatement result = connection.prepareStatement(this.getSql());
        int max = this.arguments.size();
        for (int i = 0; i < max; ++i) {
            result.setObject(i + 1, this.arguments.get(i));
        }
        return result;
    }

    @Nonnull
    public LoopingIterator<ResultSet> executeSelect(@Nonnull Connection connection) throws IllegalStateException, SQLException {
        return new RowIterator(this.prepareStatement(connection));
    }

    @Nonnull
    public <T> List<T> executeSelect(@Nonnull Connection connection, JdbcFunction<T> function) throws SQLException {
        ArrayList<T> result = new ArrayList<T>(128);
        try (PreparedStatement ps = this.prepareStatement(connection);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                result.add(function.apply(rs));
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(@Nonnull Connection connection) throws IllegalStateException {
        try (PreparedStatement ps = this.prepareStatement(connection);){
            int n = ps.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new IllegalStateException(this.getSql(), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public <T> T uniqueValue(@Nonnull Class<T> resultType, @Nonnull Connection connection) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public <T> Optional<T> uniqueValueOptional(@Nonnull Class<T> resultType, @Nonnull Connection connection) {
        return Optional.ofNullable(this.uniqueValue(resultType, connection));
    }

    @Nonnull
    public String getSql(boolean preview) {
        int i;
        StringBuilder result = new StringBuilder(this.getBufferSizeEstimation(preview));
        ValuePrinter printer = preview ? JdbcBuilder.createValuePrinter(result) : null;
        int max = this.sql.size();
        for (i = 0; i < max; ++i) {
            CharSequence item = this.sql.get(i);
            if (item instanceof SqlEnvelope) {
                SqlEnvelope env = (SqlEnvelope)item;
                if (env.isColumn()) {
                    if (env.getColumnOrder() > 0) {
                        result.append(ITEM_SEPARATOR);
                    }
                    result.append(' ');
                }
            } else if (i > 0) {
                result.append(' ');
            }
            if (printer != null && item instanceof MarkerEnvelope) {
                printer.appendValue(((MarkerEnvelope)item).getValue());
                continue;
            }
            result.append(item);
        }
        if (this.insertMode) {
            result.append(" VALUES (");
            max = this.arguments.size();
            for (i = 0; i < max; ++i) {
                result.append(i > 0 ? ITEM_SEPARATOR : "").append(' ');
                if (printer != null) {
                    printer.appendValue(this.arguments.get(i));
                    continue;
                }
                result.append(VALUE_MARKER);
            }
            result.append(" )");
        }
        return result.toString();
    }

    @Nonnull
    protected static ValuePrinter createValuePrinter(@Nonnull StringBuilder result) {
        return new ValuePrinter(VALUE_MARKER, "'", result);
    }

    protected int getBufferSizeEstimation(boolean preview) {
        int averageItemSize = 8;
        return (this.sql.size() + 2 - (this.insertMode ? 0 : this.arguments.size())) * 8 + this.arguments.size() * (preview ? 10 : 3);
    }

    @Nonnull
    public String getSql() {
        return this.getSql(false);
    }

    @Nonnull
    public String toString() {
        return this.getSql(true);
    }

    protected static class SqlEnvelope
    extends ProxySequence {
        private final short columnOrder;

        protected SqlEnvelope(@Nonnull CharSequence sql) {
            this(sql, -1);
        }

        protected SqlEnvelope(@Nonnull CharSequence sql, int columnOrder) {
            super(sql);
            this.columnOrder = (short)columnOrder;
        }

        public boolean isColumn() {
            return this.columnOrder >= 0;
        }

        public int getColumnOrder() {
            return this.columnOrder;
        }
    }

    protected static class MarkerEnvelope
    extends ProxySequence {
        @Nonnull
        private final Object value;

        protected MarkerEnvelope(@Nonnull Object value) {
            super(JdbcBuilder.VALUE_MARKER);
            this.value = value;
        }

        @Nonnull
        public Object getValue() {
            return this.value;
        }
    }
}

