/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.thread;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.thread.Jobs;
import org.ujorm.tools.thread.MultiJob;
import org.ujorm.tools.thread.ParallelJob;

public class JobContext {
    @Nullable
    private final ExecutorService threadPool;
    @Nonnull
    private final Duration timeout;

    protected JobContext(@Nullable ExecutorService threadPool, @Nonnull Duration timeout) {
        this.threadPool = threadPool;
        this.timeout = Assert.notNull(timeout, "timeout");
    }

    @Nonnull
    public Duration getTimeout() {
        return this.timeout;
    }

    protected final boolean noThreadPool() {
        return this.threadPool == null;
    }

    protected final boolean hasForkJoinPool() {
        return this.threadPool instanceof ForkJoinPool;
    }

    @Nullable
    public <T extends ExecutorService> T getThreadPool() {
        return (T)this.threadPool;
    }

    public void shutdown() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }

    public void shutdownNow() {
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
        }
    }

    public <P> Jobs<P> forEach(P ... params) {
        return this.forEach(Stream.of(params));
    }

    public <P> Jobs<P> forEach(@Nonnull Collection<P> params) {
        return this.forEach(params.stream());
    }

    public <P> Jobs<P> forEach(@Nonnull Stream<P> params) {
        return this.noThreadPool() ? new Jobs(params, this.getTimeout()) : (this.hasForkJoinPool() ? new ParallelJob<P>(params, this) : new MultiJob<P>(params, this));
    }

    public static JobContext forSingleThread() {
        return JobContext.forAny(null, Duration.ofHours(1L));
    }

    public static JobContext forMultiJob(int nThreads) {
        return JobContext.forMultiJob(nThreads, Duration.ofHours(1L));
    }

    public static JobContext forMultiJob(int nThreads, Duration timeout) {
        return new JobContext(Executors.newFixedThreadPool(nThreads), timeout);
    }

    public static JobContext forParallelJob(int parallelism) {
        return JobContext.forParallelJob(parallelism, Duration.ofHours(1L));
    }

    public static JobContext forParallelJob(Duration timeout) {
        return JobContext.forAny(ForkJoinPool.commonPool(), timeout);
    }

    public static JobContext forParallelJob(int parallelism, Duration timeout) {
        return JobContext.forAny(new ForkJoinPool(parallelism), timeout);
    }

    public static JobContext forAny(@Nullable ExecutorService threadPool, @Nonnull Duration timeout) {
        return new JobContext(threadPool, timeout);
    }
}

