/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.tools.msg.MsgFormatter;

@Immutable
public class ValueFormatter
extends MsgFormatter {
    private static final char THREE_DOTS = '\u2026';
    private final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    protected final String valueBorder;

    protected ValueFormatter() {
        this.valueBorder = "";
    }

    protected ValueFormatter(@Nonnull String mark, @Nonnull String textBorder) {
        super(mark);
        this.valueBorder = textBorder;
    }

    @Override
    protected void writeValue(@Nullable Object value, @Nonnull StringBuilder out, boolean marked) {
        Object val;
        Object object = val = value instanceof Supplier ? ((Supplier)value).get() : value;
        if (!marked) {
            out.append(' ');
        }
        if (val == null) {
            out.append((String)null);
        } else if (val instanceof CharSequence) {
            out.append(this.valueBorder);
            this.writeLongValue((CharSequence)val, out);
            out.append(this.valueBorder);
        } else if (val instanceof Number) {
            out.append(String.valueOf(val));
        } else if (val instanceof Date) {
            out.append(this.valueBorder);
            String format = val instanceof java.sql.Date ? "yyyy-MM-dd" : "yyyy-MM-dd'T'HH:mm:ss.SSS";
            out.append(new SimpleDateFormat(format, Locale.ENGLISH).format((Date)val));
            out.append(this.valueBorder);
        } else if (val instanceof byte[]) {
            out.append(this.valueBorder);
            this.writeByteArray((byte[])val, out);
            out.append(this.valueBorder);
        } else if (val instanceof Character) {
            out.append(this.valueBorder);
            out.append((Character)val);
            out.append(this.valueBorder);
            out.append(((Throwable)val).getMessage());
        } else if (val instanceof Enum) {
            out.append(((Enum)val).name());
        } else if (val instanceof Throwable) {
            out.append(val.getClass().getSimpleName());
            out.append(':');
            out.append(((Throwable)val).getMessage());
        } else {
            this.writeLongValue(String.valueOf(val), out);
        }
    }

    protected void writeByteArray(@Nonnull byte[] bytes, @Nonnull StringBuilder out) {
        int v;
        int i;
        int length = bytes != null ? bytes.length : -1;
        int limit = this.getSizeLimit() >> 1;
        int half = limit - 4 >> 1;
        int max = length > limit ? half : length;
        for (i = 0; i < max; ++i) {
            v = bytes[i] & 0xFF;
            out.append(this.HEX_ARRAY[v >>> 4]);
            out.append(this.HEX_ARRAY[v & 0xF]);
        }
        if (length > limit) {
            out.append('\u2026');
            out.append(String.valueOf(length));
            out.append('\u2026');
            for (i = length - half; i < length; ++i) {
                v = bytes[i] & 0xFF;
                out.append(this.HEX_ARRAY[v >>> 4]);
                out.append(this.HEX_ARRAY[v & 0xF]);
            }
        }
    }

    protected void writeLongValue(@Nonnull CharSequence value, @Nonnull StringBuilder out) {
        int length = value != null ? value.length() : -1;
        int limit = this.getSizeLimit();
        int half = limit - 4 >> 1;
        if (length > limit) {
            out.append(value, 0, half);
            out.append('\u2026');
            out.append(String.valueOf(length));
            out.append('\u2026');
            out.append(value, length - half, length);
        } else {
            out.append(value);
        }
    }

    protected int getSizeLimit() {
        return 32;
    }

    @Nonnull
    public static <T> String format(@Nullable String messageTemplate, T ... arguments) {
        return new ValueFormatter().formatMsg(messageTemplate, arguments);
    }

    @Nonnull
    public static <T> String formatSql(@Nullable String sqlTemplate, T ... arguments) {
        return new ValueFormatter("?", "'").formatMsg(sqlTemplate, arguments);
    }
}

