/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.thread;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;

public class Jobs<P> {
    protected static final String REQUIRED_INPUT_TEMPLATE_MSG = "The {} is required";
    @Nonnull
    private final Stream<P> params;
    @Nonnull
    protected Duration timeout;

    protected Jobs(@Nonnull Stream<P> params, @Nonnull Duration timeout) {
        Assert.notNull(params, REQUIRED_INPUT_TEMPLATE_MSG, "params");
        Assert.notNull(timeout, REQUIRED_INPUT_TEMPLATE_MSG, "timeout");
        this.params = params;
        this.timeout = timeout;
    }

    @Nonnull
    protected final Stream<P> getParallel() {
        Stream result = (Stream)this.params.parallel();
        return result.isParallel() ? result : this.params.collect(Collectors.toList()).parallelStream();
    }

    public final Jobs<P> setTimeout(@Nonnull Duration timeout) {
        this.timeout = Assert.notNull(timeout, REQUIRED_INPUT_TEMPLATE_MSG, "timeout");
        return this;
    }

    public <R> Stream<R> run(@Nonnull UserFunction<P, R> job) {
        return this.params.map(job).filter(Objects::nonNull);
    }

    public <R> Stream<R> runOfStream(@Nonnull UserFunction<P, Stream<R>> job) {
        return this.params.map(job).flatMap(Function.identity());
    }

    public <R> long runOfSum(@Nonnull UserFunction<P, Integer> job) throws JobException {
        return this.run(job).mapToLong(n -> n.intValue()).sum();
    }

    public static interface UserFunction<T, R>
    extends Function<T, R> {
        @Override
        @Nullable
        default public R apply(T t) {
            try {
                return this.run(t);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new JobException(e);
            }
        }

        @Nullable
        public R run(T var1) throws Exception;
    }

    public static final class JobException
    extends IllegalStateException {
        public JobException(@Nonnull Throwable cause) {
            super(Assert.notNull(cause, Jobs.REQUIRED_INPUT_TEMPLATE_MSG, "cause"));
        }

        @Override
        @Nonnull
        public Throwable getCause() {
            return super.getCause();
        }
    }
}

