/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.builder;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.AbstractElement;
import org.ujorm.tools.xml.builder.XmlPrinter;

public class XmlBuilder
extends AbstractElement<XmlBuilder> {
    protected static final String HTML = "html";
    protected static final String REQUIRED_MSG = "The argument {} is required";
    @Nonnull
    private final XmlPrinter writer;
    private final int level;
    @Nullable
    private XmlBuilder lastChild;
    private boolean lastText;
    private boolean filled;
    private boolean closed;
    private boolean attributeMode = true;

    public XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer, int level) throws IOException {
        this(name, writer, level, true);
    }

    protected XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer, int level, boolean printName) throws IOException {
        super(Assert.notNull(name, REQUIRED_MSG, "name"));
        this.writer = Assert.notNull(writer, REQUIRED_MSG, "writer");
        this.level = level;
        if (printName) {
            writer.writeBeg(this, this.lastText);
        }
    }

    public XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer) throws IOException {
        this(name, writer, 0);
    }

    @Nonnull
    protected XmlBuilder nextChild(@Nullable XmlBuilder element) throws IOException {
        Assert.isFalse(this.closed, "The node {} was closed", this.name);
        if (!this.filled) {
            this.writer.writeMid(this);
        }
        if (this.lastChild != null) {
            this.lastChild.close();
        }
        if (element != null) {
            this.writer.writeBeg(element, this.lastText);
        }
        this.filled = true;
        this.attributeMode = false;
        this.lastChild = element;
        this.lastText = element == null;
        return element;
    }

    @Override
    @Nonnull
    public final <T extends XmlBuilder> T addElement(@Nonnull String name) throws IOException {
        return (T)this.nextChild(new XmlBuilder(name, this.writer, this.level + 1, false));
    }

    @Override
    @Nonnull
    public final <T extends XmlBuilder> T setAttrib(@Nonnull String name, @Nullable Object value) throws IOException {
        Assert.hasLength(name, REQUIRED_MSG, "name");
        Assert.isFalse(this.closed, "The node {} was closed", this.name);
        Assert.isTrue(this.attributeMode, "Writing attributes to the {} node was closed", this.name);
        if (value != null) {
            this.writer.writeAttrib(name, value, this);
        }
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlBuilder> T addText(@Nullable Object value) throws IOException {
        this.nextChild(null);
        this.writer.writeValue(value, this, null);
        return (T)this;
    }

    @Override
    @Nonnull
    public final <T extends XmlBuilder> T addRawText(@Nullable Object value) throws IOException {
        this.nextChild(null);
        this.writer.writeRawValue(value, this);
        return (T)this;
    }

    @Override
    @Nonnull
    @Deprecated
    public final <T extends XmlBuilder> T addComment(@Nullable CharSequence comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    @Deprecated
    public final <T extends XmlBuilder> T addCDATA(@Nullable CharSequence charData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.lastChild != null) {
                this.lastChild.close();
            }
            this.writer.writeEnd(this);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public boolean isLastText() {
        return this.lastText;
    }

    public XmlPrinter getWriter() {
        return this.writer;
    }

    @Override
    @Nonnull
    public String toString() {
        return this.writer.toString();
    }

    @Nonnull
    public static XmlBuilder forHtml(@Nonnull Appendable response) throws IOException {
        return new XmlBuilder(HTML, XmlPrinter.forHtml(response));
    }

    @Nonnull
    public static XmlBuilder forNiceHtml(@Nonnull Appendable response) throws IOException {
        return new XmlBuilder(HTML, XmlPrinter.forNiceHtml(response));
    }
}

