/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.config.Formatter;
import org.ujorm.tools.xml.config.XmlConfig;

public class DefaultXmlConfig
implements XmlConfig {
    public static final String DEFAULT_INTENDATION = "    ";
    public static final String DEFAULT_NEW_LINE = "\n";
    public static final int DEFAULT_FIRST_LEVEL = -2147483647;
    public static final String REQUIRED_MSG = "The argument {} is required";
    private boolean dom = false;
    @Nullable
    protected String doctype;
    @Nonnull
    private Charset charset = StandardCharsets.UTF_8;
    private int firstLevel = -2147483647;
    @Nonnull
    private String indentation = "";
    @Nonnull
    private String defaultValue = "";
    @Nonnull
    private String newLine = "\n";
    private boolean cacheAllowed;
    @Nonnull
    private Formatter formatter = (value, element, attribute) -> value != null ? value.toString() : "";

    @Override
    @Nonnull
    public String getDoctype() {
        return this.nonnull(this.doctype, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @Nonnull
    protected final <T> T nonnull(@Nullable T value, @Nonnull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public void setDoctype(@Nullable String doctype) {
        this.doctype = doctype;
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(@Nonnull Charset charset) {
        this.charset = Assert.notNull(charset, REQUIRED_MSG, "charset");
    }

    public final void setNiceFormat() {
        this.setNiceFormat(DEFAULT_INTENDATION);
    }

    public final void setNiceFormat(@Nullable String indentation) {
        this.firstLevel = 0;
        this.indentation = Check.hasLength(indentation) ? indentation : DEFAULT_INTENDATION;
        this.newLine = DEFAULT_NEW_LINE;
    }

    public final void setCompressedFormat() {
        this.firstLevel = -2147483647;
        this.indentation = "";
        this.newLine = "";
    }

    @Override
    public int getFirstLevel() {
        return this.firstLevel;
    }

    public void setFirstLevel(int firstLevel) {
        this.firstLevel = firstLevel;
    }

    @Override
    @Nonnull
    public String getIndentation() {
        return this.nonnull(this.indentation, "");
    }

    public void setIndentationSpace(@Nonnull String indentation) {
        this.indentation = Assert.notNull(indentation, REQUIRED_MSG, "indentation");
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nonnull
    public Formatter getFormatter() {
        return this.formatter;
    }

    public void setDefaultValue(@Nonnull String defaultValue) {
        this.defaultValue = Assert.notNull(defaultValue, "defaultValue");
    }

    public void setDom(boolean dom) {
        this.dom = dom;
    }

    @Override
    public boolean isCacheAllowed() {
        return this.cacheAllowed;
    }

    public void setCacheAllowed(boolean cacheAllowed) {
        this.cacheAllowed = cacheAllowed;
    }

    @Override
    public String getNewLine() {
        return this.newLine;
    }

    public void setNewLine(@Nonnull String newLine) {
        this.newLine = Assert.notNull(newLine, "newLine");
    }

    public void setFormatter(@Nonnull Formatter formatter) {
        this.formatter = Assert.notNull(formatter, "formatter");
    }
}

