/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.builder;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.builder.XmlPrinter;

public class XmlBuilder
implements ApiElement<XmlBuilder> {
    protected static final String HTML = "html";
    protected static final String REQUIRED_MSG = "The argument {} is required";
    @Nonnull
    protected final String name;
    @Nonnull
    private final XmlPrinter writer;
    private final int level;
    @Nullable
    private XmlBuilder lastChild;
    private boolean lastText;
    private boolean filled;
    private boolean closed;
    private boolean attributeMode = true;

    public XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer, int level) {
        this(name, writer, level, true);
    }

    protected XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer, int level, boolean printName) {
        this.name = name.toString();
        this.writer = Assert.notNull(writer, REQUIRED_MSG, "writer");
        this.level = level;
        if (printName) {
            try {
                writer.writeBeg(this, this.lastText);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public XmlBuilder(@Nonnull CharSequence name, @Nonnull XmlPrinter writer) {
        this(name, writer, 0);
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    protected XmlBuilder nextChild(@Nullable XmlBuilder element) {
        Assert.isFalse(this.closed, "The node {} was closed", this.name);
        if (!this.filled) {
            try {
                this.writer.writeMid(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        if (this.lastChild != null) {
            this.lastChild.close();
        }
        if (element != null) {
            try {
                this.writer.writeBeg(element, this.lastText);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        this.filled = true;
        this.attributeMode = false;
        this.lastChild = element;
        this.lastText = element == null;
        return element;
    }

    @Override
    @Nonnull
    public final XmlBuilder addElement(@Nonnull String name) {
        XmlBuilder xb = new XmlBuilder(name, this.writer, this.level + 1, false);
        return this.nextChild(xb);
    }

    @Override
    @Nonnull
    public final XmlBuilder setAttribute(@Nonnull String name, @Nullable Object value) {
        Assert.hasLength(name, REQUIRED_MSG, "name");
        Assert.isFalse(this.closed, "The node {} was closed", this.name);
        Assert.isTrue(this.attributeMode, "Writing attributes to the {} node was closed", this.name);
        if (value != null) {
            try {
                this.writer.writeAttrib(name, value, this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this;
    }

    @Override
    @Nonnull
    public final XmlBuilder addText(@Nullable Object value) {
        try {
            this.nextChild(null);
            this.writer.writeValue(value, this, null);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    @Nonnull
    public final XmlBuilder addRawText(@Nullable Object value) {
        try {
            this.nextChild(null);
            this.writer.writeRawValue(value, this);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    @Override
    @Nonnull
    @Deprecated
    public final XmlBuilder addComment(@Nullable CharSequence comment) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    @Deprecated
    public final XmlBuilder addCDATA(@Nullable CharSequence charData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void close() {
        if (!this.closed) {
            try {
                this.closed = true;
                if (this.lastChild != null) {
                    this.lastChild.close();
                }
                this.writer.writeEnd(this);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public boolean isLastText() {
        return this.lastText;
    }

    public XmlPrinter getWriter() {
        return this.writer;
    }

    @Nonnull
    public String toString() {
        return this.writer.toString();
    }

    @Nonnull
    public static XmlBuilder forHtml(@Nonnull Appendable response) {
        return new XmlBuilder(HTML, XmlPrinter.forHtml(response));
    }

    @Nonnull
    public static XmlBuilder forNiceHtml(@Nonnull Appendable response) {
        return new XmlBuilder(HTML, XmlPrinter.forNiceHtml(response));
    }
}

