/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.builder;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.xml.AbstractWriter;
import org.ujorm.tools.xml.builder.XmlBuilder;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class XmlPrinter
extends AbstractWriter {
    public XmlPrinter() {
        this(new CharArrayWriter(512));
    }

    public XmlPrinter(@Nonnull Appendable out) {
        this(out, XmlConfig.ofDefault());
    }

    public <T> XmlPrinter(@Nonnull Appendable out, @Nonnull XmlConfig config) {
        super(out, config);
        try {
            out.append(config.getDoctype());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void writeRawValue(@Nonnull Object rawValue, @Nonnull XmlBuilder element) throws IOException {
        this.out.append(rawValue.toString());
    }

    void writeAttrib(String name, Object data, XmlBuilder owner) throws IOException {
        this.out.append(' ');
        this.out.append(name);
        this.out.append('=');
        this.out.append('\"');
        this.writeValue(data, owner, name);
        this.out.append('\"');
    }

    void writeRawText(Object rawText) throws IOException {
        this.out.append(String.valueOf(rawText));
    }

    void writeBeg(XmlBuilder element, boolean lastText) throws IOException {
        if (!lastText) {
            this.writeNewLine(element.getLevel());
        }
        this.out.append('<');
        this.out.append(element.getName());
    }

    void writeMid(XmlBuilder element) throws IOException {
        this.out.append('>');
    }

    void writeEnd(XmlBuilder element) throws IOException {
        if (element.isFilled()) {
            if (this.indentationEnabled && !element.isLastText()) {
                this.writeNewLine(element.getLevel());
            }
            this.out.append('<');
            this.out.append('/');
            this.out.append(element.getName());
            this.out.append('>');
        } else {
            this.out.append('/');
            this.out.append('>');
        }
    }

    @Override
    @Nonnull
    public String toString() {
        String result = this.out.toString();
        return result != null ? result : String.valueOf(result);
    }

    public XmlBuilder createElement(@Nonnull String elementName) throws IOException {
        return new XmlBuilder(elementName, this);
    }

    public static XmlPrinter forXml() {
        return XmlPrinter.forXml(null, XmlConfig.ofDefault());
    }

    public static XmlPrinter forNiceXml() {
        DefaultXmlConfig config = XmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forXml(null, config);
    }

    public static XmlPrinter forXml(@Nullable Appendable out, @Nonnull XmlConfig config) {
        return new XmlPrinter(out != null ? out : new StringBuilder(512), config);
    }

    public static XmlPrinter forHtml() {
        return XmlPrinter.forXml(null, HtmlConfig.ofDefault());
    }

    public static XmlPrinter forHtml(Appendable out) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        return XmlPrinter.forXml(out, config);
    }

    public static XmlPrinter forNiceHtml(Appendable out) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forHtml(out, (HtmlConfig)config);
    }

    public static XmlPrinter forHtml(@Nonnull Object httpServletResponse) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static XmlPrinter forNiceHtml(@Nonnull Object httpServletResponse) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat();
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static <T> XmlPrinter forHtml(@Nullable Appendable out, @Nonnull HtmlConfig config) {
        return new XmlPrinter(out != null ? out : new StringBuilder(512), config);
    }

    public static XmlPrinter forHtml(@Nonnull Object httpServletResponse, @Nonnull Charset charset, @Nonnull String indentationSpace, boolean noCache) throws IOException {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setCharset(charset);
        config.setIndentationSpace(indentationSpace);
        config.setCacheAllowed(!noCache);
        return XmlPrinter.forHtml(httpServletResponse, (HtmlConfig)config);
    }

    public static XmlPrinter forHtml(@Nonnull Object httpServletResponse, @Nonnull HtmlConfig config) throws IOException {
        try {
            Writer writer = XmlPrinter.createWriter(httpServletResponse, config.getCharset(), config.isCacheAllowed());
            return new XmlPrinter(writer, config);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalArgumentException("Response must be type of HttpServletResponse", e);
        }
    }
}

