/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.model;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.AbstractWriter;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;
import org.ujorm.tools.xml.model.XmlModel;

public class XmlWriter
extends AbstractWriter {
    public XmlWriter() {
        this(new CharArrayWriter(512));
    }

    public XmlWriter(@Nonnull Appendable out) {
        super(out, XmlConfig.ofDefault());
    }

    public XmlWriter(@Nonnull Appendable out, @Nonnull String indentationSpace) {
        super(out, XmlWriter.createConfig(indentationSpace));
    }

    private static XmlConfig createConfig(@Nonnull String indentationSpace) {
        DefaultXmlConfig config = XmlConfig.ofDefault();
        config.setIndentationSpace(indentationSpace);
        return config;
    }

    @Nonnull
    public final XmlWriter write(int level, @Nonnull XmlModel element) throws IOException {
        return this.write(level, element.getName(), element.attributes, element.children, element);
    }

    @Nonnull
    protected XmlWriter write(int level, @Nonnull CharSequence name, @Nullable Map<String, Object> attributes, @Nullable List<Object> children, @Nonnull XmlModel element) throws IOException {
        this.out.append('<');
        this.out.append(name);
        if (Check.hasLength(attributes)) {
            assert (attributes != null);
            for (String key : attributes.keySet()) {
                this.out.append(' ');
                this.out.append(key);
                this.out.append('=');
                this.out.append('\"');
                this.writeValue(attributes.get(key), element, key);
                this.out.append('\"');
            }
        }
        if (Check.hasLength(children)) {
            assert (children != null);
            this.out.append('>');
            boolean writeNewLine = true;
            for (Object child : children) {
                if (child instanceof XmlModel) {
                    if (writeNewLine) {
                        this.writeNewLine(level);
                    } else {
                        writeNewLine = true;
                    }
                    this.write(level + 1, (XmlModel)child);
                    continue;
                }
                if (child instanceof XmlModel.RawEnvelope) {
                    this.writeRawValue(((XmlModel.RawEnvelope)child).get().toString(), element);
                    writeNewLine = false;
                    continue;
                }
                this.writeValue(child, element, null);
                writeNewLine = false;
            }
            if (this.indentationEnabled && writeNewLine && level >= 0) {
                this.writeNewLine(level - 1);
            }
            this.out.append('<');
            this.out.append('/');
            this.out.append(name);
        } else {
            this.out.append('/');
        }
        this.out.append('>');
        return this;
    }
}

