/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.common.ObjectUtils;

public final class MessageArg<T>
implements Serializable,
CharSequence {
    @Nonnull
    private final String name;
    @Nullable
    private final String format;
    @Nonnull
    private final String code;

    public MessageArg(@Nonnull String name) {
        this(name, null);
    }

    public MessageArg(@Nonnull String name, @Nullable String format) {
        Assert.notNull(name, "Name is required", name);
        Assert.isTrue(name.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), name);
        Assert.isTrue(format == null || format.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), format);
        this.name = name;
        this.format = format;
        this.code = this.toCode();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public final String name() {
        return this.name;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @Nonnull
    public String getCode() {
        return this.code;
    }

    @Nonnull
    protected final String toCode() {
        StringBuilder result = new StringBuilder("${".length() + 1 + this.name.length() + (this.format != null ? this.format.length() + 1 : 0));
        result.append("${").append(this.name);
        if (Check.hasLength(this.format)) {
            result.append(',').append(this.format);
        }
        result.append('}');
        return result.toString();
    }

    public <T> T getValue(Map<String, Object> map) {
        return (T)map.get(this.name);
    }

    @Override
    public final String toString() {
        return this.getCode();
    }

    @Override
    public final int length() {
        return this.getCode().length();
    }

    @Override
    public final char charAt(int index) {
        return this.getCode().charAt(index);
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.getCode().subSequence(start, end);
    }

    public boolean equals(Object obj) {
        return this == obj || ObjectUtils.check(obj, MessageArg.class, v -> Objects.equals(this.name, v.name) && Objects.equals(this.format, v.format));
    }

    public static <T> MessageArg<T> of(@Nonnull String name) {
        return new MessageArg<T>(name);
    }

    public static <T> MessageArg<T> of(@Nonnull String name, @Nullable String format) {
        return new MessageArg<T>(name, format);
    }
}

