/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.msg.MessageArg;

@Immutable
public class MessageService {
    public static final String PARAM_BEG = "${";
    public static final char PARAM_END = '}';
    @Nonnull
    protected final Locale defaultLocale;

    public MessageService() {
        this(Locale.ENGLISH);
    }

    public MessageService(@Nonnull Locale defaultLocale) {
        this.defaultLocale = Assert.notNull(defaultLocale, "defaultLocale");
    }

    public <T> Map<String, Object> map(T ... args) {
        int max = args.length;
        HashMap<String, Object> result = new HashMap<String, Object>(max >> 1);
        for (int i = 1; i < max; i += 2) {
            result.put(this.convertKey(args[i - 1]), args[i]);
        }
        return result;
    }

    public <T> String template(T ... args) {
        StringBuilder result = new StringBuilder(256);
        for (T arg : args) {
            result.append(arg);
        }
        return result.toString();
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args) {
        return this.format(msg, args, null);
    }

    public final String format(@Nullable String msg, @Nullable Locale locale, @Nonnull CharSequence key, @Nullable Object value, Object ... keyValuePairs) {
        Map<String, Object> map = this.map(keyValuePairs);
        map.put(this.convertKey(key), value);
        return this.format(msg, map, locale);
    }

    public final String format(@Nullable String msg, @Nullable Map<String, Object> args, @Nullable Locale locale) {
        try {
            return this.format(null, msg, args, locale);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final String format(@Nullable Writer writer, @Nullable String msg, @Nullable Map<String, Object> args, @Nullable Locale locale) throws IOException {
        int i;
        if (msg == null || args == null) {
            return String.valueOf(msg);
        }
        int max = msg.length();
        Writer result = writer != null ? writer : new CharArrayWriter(Math.max(32, max + (max >> 1)));
        int last = 0;
        while ((i = msg.indexOf(PARAM_BEG, last)) >= 0) {
            Object val;
            String expr;
            int end = msg.indexOf(125, i);
            int formatIndex = (expr = msg.substring(i + PARAM_BEG.length(), end)).indexOf(44);
            String key = expr.substring(0, formatIndex >= 0 ? formatIndex : expr.length());
            Object value = args.get(key);
            Object object = val = value instanceof Supplier ? ((Supplier)value).get() : value;
            if (val != null) {
                result.append(msg, last, i);
                if (formatIndex > 0) {
                    new Formatter(result, locale != null ? locale : this.defaultLocale).format(expr.substring(1 + formatIndex), val, val, val, val, val, val);
                } else {
                    this.writeValue(val, result, locale);
                }
            } else {
                result.append(msg, last, end + 1);
            }
            last = end + 1;
        }
        result.append(msg, last, max);
        return writer != null ? "" : result.toString();
    }

    @Nullable
    protected String convertKey(@Nonnull Object key) {
        return key instanceof MessageArg ? ((MessageArg)key).getName() : key.toString();
    }

    protected void writeValue(@Nonnull Object value, @Nonnull Writer writer, @Nullable Locale locale) throws IOException {
        if (value instanceof Throwable) {
            PrintWriter pw = new PrintWriter(writer);
            ((Throwable)value).printStackTrace(pw);
            pw.flush();
        } else {
            writer.append(value.toString());
        }
    }

    public static final String formatMsg(@Nullable String template, @Nullable Map<String, Object> args) {
        return new MessageService().format(template, args);
    }

    public static final String formatMsg(@Nullable String template, @Nonnull CharSequence key, @Nullable Object value, Object ... keyValuePairs) {
        return new MessageService().format(template, null, key, value, keyValuePairs);
    }
}

