/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class DefaultHtmlConfig
extends DefaultXmlConfig
implements HtmlConfig {
    @Nonnull
    private CharSequence title = "Demo";
    @Nonnull
    private CharSequence[] cssLinks = new CharSequence[0];
    @Nonnull
    private CharSequence language = "en";
    @Nonnull
    private String contentType = "text/html";
    private boolean buildDom = false;
    private boolean htmlHeaderRequest = true;
    private CharSequence rawHeaderText = null;
    private String rootElementName = "html";

    @Override
    @Nonnull
    public String getDoctype() {
        return this.nonnull(this.doctype, "<!DOCTYPE html>");
    }

    @Override
    @Nonnull
    public CharSequence getTitle() {
        return this.title;
    }

    @Override
    public CharSequence[] getCssLinks() {
        return this.cssLinks;
    }

    @Override
    @Nonnull
    public Optional<CharSequence> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    @Override
    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isDocumentObjectModel() {
        return this.buildDom;
    }

    @Override
    public boolean isHtmlHeaderRequest() {
        return this.htmlHeaderRequest;
    }

    @Override
    public CharSequence getRowHeaderText() {
        return this.rawHeaderText;
    }

    @Override
    public String getRootElementName() {
        return this.rootElementName;
    }

    public void setTitle(@Nonnull CharSequence title) {
        this.title = Assert.hasLength(title, "title");
    }

    public void setCssLinks(CharSequence ... cssLinks) {
        this.cssLinks = Assert.notNull(cssLinks, "The argument {} is required", "cssLinks");
    }

    public void setLanguage(@Nonnull CharSequence language) {
        this.language = language;
    }

    public void setContentType(@Nonnull String contentType) {
        this.contentType = Assert.notNull(contentType, "The argument {} is required", "contentType");
    }

    public void setDocumentObjectModel(boolean buildDom) {
        this.buildDom = buildDom;
    }

    public void setHtmlHeaderRequest(boolean htmlHeaderRequest) {
        this.htmlHeaderRequest = htmlHeaderRequest;
    }

    public void setRootElementName(@Nonnull String rootElementName) {
        this.rootElementName = Assert.notNull(rootElementName, "The argument {} is required", "rootElementName");
    }

    public void setRawHedaderCode(@Nullable String rawHeaderText) {
        this.rawHeaderText = Assert.notNull(rawHeaderText, "The argument {} is required", "rawHeaderText");
    }
}

