/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;

public interface HtmlConfig
extends XmlConfig {
    @Nonnull
    public CharSequence getTitle();

    @Nonnull
    public CharSequence[] getCssLinks();

    @Nonnull
    public Optional<CharSequence> getLanguage();

    @Nonnull
    public String getContentType();

    public boolean isDocumentObjectModel();

    public boolean isHtmlHeaderRequest();

    @Nullable
    public CharSequence getRawHeaderText();

    public CharSequence getRootElementName();

    default public DefaultHtmlConfig cloneForAjax() {
        DefaultHtmlConfig result = new DefaultHtmlConfig(this);
        result.setNiceFormat();
        result.setRootElementName("");
        result.setDoctype("");
        result.setHtmlHeader(false);
        result.setCacheAllowed(false);
        return result;
    }

    @Nonnull
    public static DefaultHtmlConfig ofDefault() {
        return new DefaultHtmlConfig();
    }

    @Nonnull
    public static DefaultHtmlConfig ofElementName(@Nullable String rootElementName) {
        return HtmlConfig.ofElement(rootElementName, true);
    }

    @Nonnull
    public static DefaultHtmlConfig ofElement(@Nullable String rootElementName, boolean enabled) {
        DefaultHtmlConfig result = HtmlConfig.ofDefault();
        result.setRootElementName(enabled ? rootElementName : null);
        result.setHtmlHeader(false);
        result.setDoctype("");
        return result;
    }

    @Nonnull
    public static DefaultHtmlConfig ofEmptyElement() {
        DefaultHtmlConfig result = HtmlConfig.ofElement("", false);
        result.setHtmlHeader(false);
        result.setDoctype("");
        result.setNewLine("");
        return result;
    }

    public static DefaultHtmlConfig of(@Nonnull HtmlConfig htmlConfig) {
        return new DefaultHtmlConfig(htmlConfig);
    }
}

