/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.config.Formatter;
import org.ujorm.tools.xml.config.XmlConfig;

public class DefaultXmlConfig
implements XmlConfig {
    public static final String DEFAULT_INTENDATION = "    ";
    public static final String DEFAULT_NEW_LINE = "\n";
    public static final int DEFAULT_FIRST_LEVEL = -2147483647;
    public static final String REQUIRED_MSG = "The argument {} is required";
    public static final String EMPTY = "";
    @Nullable
    protected CharSequence doctype;
    @Nonnull
    private Charset charset = StandardCharsets.UTF_8;
    private int firstLevel = -2147483647;
    @Nonnull
    private CharSequence indentation = "";
    @Nonnull
    private CharSequence defaultValue = "";
    @Nonnull
    private CharSequence newLine = "\n";
    private boolean cacheAllowed;
    @Nonnull
    private Formatter formatter = (value, element, attribute) -> value != null ? value.toString() : EMPTY;

    public DefaultXmlConfig() {
    }

    public DefaultXmlConfig(@Nonnull XmlConfig config) {
        this.doctype = config.getDoctype();
        this.charset = config.getCharset();
        this.firstLevel = config.getFirstLevel();
        this.indentation = config.getIndentation();
        this.defaultValue = config.getDefaultValue();
        this.newLine = config.getNewLine();
        this.cacheAllowed = config.isCacheAllowed();
        this.formatter = config.getFormatter();
    }

    @Override
    @Nonnull
    public CharSequence getDoctype() {
        return this.nonnull(this.doctype, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    }

    @Nonnull
    protected final <T> T nonnull(@Nullable T value, @Nonnull T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public DefaultXmlConfig setDoctype(@Nullable CharSequence doctype) {
        this.doctype = doctype;
        return this;
    }

    @Override
    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }

    public DefaultXmlConfig setCharset(@Nonnull Charset charset) {
        this.charset = Assert.notNull(charset, REQUIRED_MSG, "charset");
        return this;
    }

    public final <T extends DefaultXmlConfig> T setNiceFormat() {
        this.setNiceFormat(DEFAULT_INTENDATION);
        return (T)this;
    }

    public final DefaultXmlConfig setNiceFormat(@Nullable CharSequence indentation) {
        this.firstLevel = 0;
        this.indentation = Check.hasLength(indentation) ? indentation : DEFAULT_INTENDATION;
        this.newLine = DEFAULT_NEW_LINE;
        return this;
    }

    public final DefaultXmlConfig setCompressedFormat() {
        this.firstLevel = -2147483647;
        this.indentation = EMPTY;
        this.newLine = EMPTY;
        return this;
    }

    @Override
    public int getFirstLevel() {
        return this.firstLevel;
    }

    public DefaultXmlConfig setFirstLevel(int firstLevel) {
        this.firstLevel = firstLevel;
        return this;
    }

    @Override
    @Nonnull
    public CharSequence getIndentation() {
        return this.nonnull(this.indentation, EMPTY);
    }

    public DefaultXmlConfig setIndentationSpace(@Nonnull CharSequence indentation) {
        this.indentation = Assert.notNull(indentation, REQUIRED_MSG, "indentation");
        return this;
    }

    @Override
    public CharSequence getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @Nonnull
    public Formatter getFormatter() {
        return this.formatter;
    }

    public DefaultXmlConfig setDefaultValue(@Nonnull String defaultValue) {
        this.defaultValue = Assert.notNull(defaultValue, "defaultValue");
        return this;
    }

    @Override
    public boolean isCacheAllowed() {
        return this.cacheAllowed;
    }

    public DefaultXmlConfig setCacheAllowed(boolean cacheAllowed) {
        this.cacheAllowed = cacheAllowed;
        return this;
    }

    @Override
    public CharSequence getNewLine() {
        return this.newLine;
    }

    public DefaultXmlConfig setNewLine(@Nonnull CharSequence newLine) {
        this.newLine = Assert.notNull(newLine, "newLine");
        return this;
    }

    public DefaultXmlConfig setFormatter(@Nonnull Formatter formatter) {
        this.formatter = Assert.notNull(formatter, "formatter");
        return this;
    }
}

