/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.msg.ValueFormatter;

public class ValuePrinter
extends ValueFormatter {
    protected final Appendable out;

    public ValuePrinter(int size) {
        this(new StringBuilder(size));
    }

    public ValuePrinter(@Nonnull Appendable out) {
        this("?", "\"", out);
    }

    public ValuePrinter(@Nonnull String mark, @Nonnull String textBorder, @Nonnull Appendable out) {
        super(mark, textBorder);
        this.out = out;
    }

    @Nonnull
    public ValuePrinter appendValue(@Nullable Object value) throws IOException {
        if (value instanceof Object[]) {
            boolean first = true;
            for (Object object : (Object[])value) {
                if (first) {
                    first = !first;
                } else {
                    this.out.append(", ");
                }
                this.appendValue(object);
            }
        } else {
            super.writeValue(value, this.out, true);
        }
        return this;
    }

    public Appendable getWriter() {
        return this.out;
    }

    @Nonnull
    public String toString() {
        return this.out.toString();
    }
}

