/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.xml.AbstractWriter;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;
import org.ujorm.tools.xml.model.XmlWriter;

public class XmlModel
implements ApiElement<XmlModel>,
Serializable {
    @Nullable
    protected final CharSequence name;
    @Nullable
    protected Map<String, Object> attributes;
    @Nullable
    protected List<Object> children;

    public XmlModel(@Nonnull CharSequence name) {
        this.name = name;
    }

    public XmlModel(@Nonnull CharSequence name, @Nonnull XmlModel parent) {
        this(name);
        parent.addChild(this);
    }

    @Override
    @Nullable
    public CharSequence getName() {
        return this.name;
    }

    @Nonnull
    protected Map<String, Object> getAttribs() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        return this.attributes;
    }

    @Nonnull
    protected void addChild(@Nullable Object child) {
        if (this.children == null) {
            this.children = new ArrayList<Object>();
        }
        this.children.add(child);
    }

    @Nonnull
    public final XmlModel addElement(@Nonnull XmlModel element) {
        this.addChild(Assert.notNull(element, "The argument {} is required", "element"));
        return element;
    }

    @Override
    @Nonnull
    public XmlModel addElement(@Nonnull String name) {
        return new XmlModel(name, this);
    }

    @Override
    @Nonnull
    public final XmlModel setAttribute(@Nonnull String name, @Nullable Object value) {
        Assert.hasLength(name, "The argument {} is required", "name");
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
        return this;
    }

    @Override
    @Nonnull
    public final XmlModel addText(@Nullable Object value) {
        this.addChild(value);
        return this;
    }

    @Override
    @Nonnull
    public final XmlModel addTextTemplated(@Nullable CharSequence template, Object ... values) {
        try {
            return this.addText(AbstractWriter.FORMATTER.formatMsg((Appendable)null, template, (T[])values));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @Nonnull
    public final XmlModel addRawText(@Nullable Object value) {
        if (value != null) {
            this.addChild(new RawEnvelope(value));
        }
        return this;
    }

    @Override
    @Nonnull
    public final XmlModel addComment(@Nullable CharSequence comment) {
        if (Check.hasLength(comment)) {
            Assert.isTrue(!comment.toString().contains("-->"), "The text contains a forbidden string: -->");
            StringBuilder msg = new StringBuilder("<!--".length() + "-->".length() + comment.length() + 2);
            this.addRawText(msg.append("<!--").append(' ').append(comment).append(' ').append("-->"));
        }
        return this;
    }

    @Override
    @Nonnull
    public final XmlModel addCDATA(@Nullable CharSequence charData) {
        if (Check.hasLength(charData)) {
            int j;
            this.addRawText("<![CDATA[");
            String text = charData.toString();
            int i = 0;
            while ((j = text.indexOf("]]>", i)) >= 0) {
                this.addRawText(text.subSequence(i, j += "]]>".length()));
                i = j;
                this.addText("]]>");
                this.addRawText("<![CDATA[");
            }
            this.addRawText(i == 0 ? text : text.substring(i));
            this.addRawText("]]>");
        }
        return this;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes != null ? Collections.unmodifiableMap(this.attributes) : Collections.emptyMap();
    }

    @Nonnull
    public List<Object> getChildren() {
        return this.children != null ? Collections.unmodifiableList(this.children) : Collections.emptyList();
    }

    @Override
    public final void close() {
    }

    @Nonnull
    public String toString() {
        try {
            DefaultXmlConfig config = XmlConfig.ofDefault();
            XmlWriter writer = new XmlWriter(new StringBuilder(512).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(config.getNewLine()));
            return this.toWriter(0, writer).toString();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public XmlWriter toWriter(int level, @Nonnull XmlWriter out) throws IOException {
        return out.write(level, this);
    }

    protected static final class RawEnvelope {
        @Nonnull
        private final Object body;

        public RawEnvelope(@Nonnull Object body) {
            this.body = body;
        }

        @Nonnull
        public Object get() {
            return this.body;
        }
    }
}

