/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.common.Confessionable;

public final class Wrapper<V>
implements Comparable<Wrapper<V>>,
Confessionable {
    @Nonnull
    private final V value;
    @Nonnull
    private final Function<V, ?>[] functions;
    private final boolean nullFirst;

    private Wrapper(@Nonnull V value, boolean nullFirst, @Nonnull Function<V, ?>[] functions) {
        this.value = value;
        this.functions = functions;
        this.nullFirst = nullFirst;
    }

    @Nonnull
    public V getValue() {
        return this.value;
    }

    public Wrapper<V> wrap(@Nonnull V value) {
        return new Wrapper<V>(value, this.nullFirst, this.functions);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V ext = ((Wrapper)o).value;
        for (Function<V, ?> f : this.functions) {
            if (Objects.equals(f.apply(this.value), f.apply(ext))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        Object[] values = new Object[this.functions.length];
        for (int i = 0; i < this.functions.length; ++i) {
            values[i] = this.functions[i].apply(this.value);
        }
        return Objects.hash(values);
    }

    @Override
    public int compareTo(@Nullable Wrapper<V> wrapper) {
        if (wrapper == null) {
            return this.nullFirst ? 1 : -1;
        }
        V ext = wrapper.value;
        for (Function<V, ?> f : this.functions) {
            Comparable o2;
            Comparable o1 = (Comparable)f.apply(this.value);
            if (o1 == (o2 = (Comparable)f.apply(ext))) continue;
            if (o1 == null) {
                return this.nullFirst ? -1 : 1;
            }
            if (o2 == null) {
                return this.nullFirst ? 1 : -1;
            }
            int result = o1.compareTo(o2);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public Appendable confessTo(Appendable writer) throws IOException {
        writer.append(this.value.toString());
        return writer;
    }

    public static final <D, P> Wrapper<D> of(@Nonnull D value, Function<D, P> ... functions) {
        return Wrapper.of(value, true, functions);
    }

    public static final <D, P> Wrapper<D> of(@Nonnull D value, boolean nullFirst, Function<D, P> ... functions) {
        Assert.hasLength(functions, new String[]{"Function is required"});
        return new Wrapper<D>(value, nullFirst, functions);
    }
}

