/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config.impl;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultXmlConfig;

public class DefaultHtmlConfig
extends DefaultXmlConfig
implements HtmlConfig {
    @Nonnull
    private CharSequence title = "Demo";
    @Nonnull
    private CharSequence[] cssLinks = new CharSequence[0];
    @Nonnull
    private CharSequence language = "en";
    @Nonnull
    private String contentType = "text/html";
    private boolean buildDom = false;
    private boolean htmlHeaderRequest = true;
    @Nullable
    private CharSequence rawHeaderText = null;
    private CharSequence rootElementName = "html";

    public DefaultHtmlConfig() {
    }

    public DefaultHtmlConfig(@Nonnull HtmlConfig htmlConfig) {
        super(htmlConfig);
        this.title = htmlConfig.getTitle();
        this.cssLinks = htmlConfig.getCssLinks();
        this.language = htmlConfig.getLanguage().orElse(null);
        this.contentType = htmlConfig.getContentType();
        this.buildDom = htmlConfig.isDocumentObjectModel();
        this.htmlHeaderRequest = htmlConfig.isDocumentObjectModel();
        this.rawHeaderText = htmlConfig.getRawHeaderText();
        this.rootElementName = htmlConfig.getRootElementName();
    }

    @Override
    @Nonnull
    public CharSequence getDoctype() {
        return this.nonnull(this.doctype, "<!DOCTYPE html>");
    }

    @Override
    @Nonnull
    public CharSequence getTitle() {
        return this.title;
    }

    @Override
    public CharSequence[] getCssLinks() {
        return this.cssLinks;
    }

    @Override
    @Nonnull
    public Optional<CharSequence> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    @Override
    @Nonnull
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public boolean isDocumentObjectModel() {
        return this.buildDom;
    }

    @Override
    public boolean isHtmlHeaderRequest() {
        return this.htmlHeaderRequest;
    }

    @Override
    public CharSequence getRawHeaderText() {
        return this.rawHeaderText;
    }

    @Override
    public CharSequence getRootElementName() {
        return this.rootElementName;
    }

    public DefaultHtmlConfig setTitle(@Nonnull CharSequence title) {
        this.title = Assert.notNull(title, "title");
        return this;
    }

    public DefaultHtmlConfig setCssLinks(CharSequence ... cssLinks) {
        this.cssLinks = Assert.notNull(cssLinks, "The argument {} is required", "cssLinks");
        return this;
    }

    public DefaultHtmlConfig setLanguage(@Nonnull CharSequence language) {
        this.language = language;
        return this;
    }

    public DefaultHtmlConfig setContentType(@Nonnull String contentType) {
        this.contentType = Assert.notNull(contentType, "The argument {} is required", "contentType");
        return this;
    }

    @Deprecated
    public void setDom(boolean buildDom) {
        this.setDocumentObjectModel(buildDom);
    }

    public DefaultHtmlConfig setDocumentObjectModel(boolean buildDom) {
        this.buildDom = buildDom;
        return this;
    }

    public DefaultHtmlConfig setHtmlHeader(boolean htmlHeaderRequest) {
        this.htmlHeaderRequest = htmlHeaderRequest;
        return this;
    }

    public DefaultHtmlConfig setRootElementName(@Nullable String rootElementName) {
        this.rootElementName = rootElementName;
        return this;
    }

    public DefaultHtmlConfig setRawHedaderCode(@Nullable String rawHeaderText) {
        this.rawHeaderText = Assert.notNull(rawHeaderText, "The argument {} is required", "rawHeaderText");
        return this;
    }
}

