/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.common.Joinable;

public abstract class StreamUtils {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

    private StreamUtils() {
    }

    public static Stream<String> rowsOfUrl(@Nonnull URL url) throws IOException {
        InputStream is = url.openStream();
        Assert.notNull(is, "Resource is not available: {}", url);
        return (Stream)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().onClose(() -> {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't close: " + url, e);
            }
        });
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator) {
        return StreamUtils.toStream(iterator, false);
    }

    public static <T> Stream<T> toStream(@Nonnull Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    @Nonnull
    public static <T> Collector<T, ?, ArrayDeque<T>> collectToDequeue() {
        return Collectors.toCollection(ArrayDeque::new);
    }

    @Nonnull
    public static <D, R> Joinable<D, R> toJoinable(@Nonnull Function<D, R> fce) {
        return Joinable.of(fce);
    }
}

