/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.IOException;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.ujorm.tools.Check;
import org.ujorm.tools.common.ObjectUtils;

@Immutable
public class MsgFormatter {
    @Nullable
    private static final Appendable NO_WRITER = null;
    protected static final String DEFAULT_MARK = "{}";
    protected static final char SEPARATOR = ' ';
    private final String mark;

    protected MsgFormatter() {
        this(DEFAULT_MARK);
    }

    protected MsgFormatter(@Nonnull String mark) {
        this.mark = mark;
    }

    @Nonnull
    public <T> String formatMsg(@Nullable Appendable writer, @Nullable CharSequence messageTemplate, T ... argumentValues) throws IOException {
        String template = String.valueOf(messageTemplate);
        if (!Check.hasLength(argumentValues)) {
            return template;
        }
        T[] arguments = argumentValues.length == 1 && argumentValues[0] instanceof Object[] ? (Object[])argumentValues[0] : argumentValues;
        int max = template.length();
        Appendable out = writer != null ? writer : new StringBuilder(Math.max(32, max + (max >> 1)));
        int last = 0;
        for (T arg : arguments) {
            int i = template.indexOf(this.mark, last);
            if (i >= last) {
                out.append(template, last, i);
                last = i + this.mark.length();
                this.writeValue(arg, out, true);
                continue;
            }
            if (last < max) {
                out.append(template, last, max);
                last = max;
            }
            this.writeValue(arg, out, false);
        }
        if (last < max) {
            out.append(template, last, max);
        }
        return writer != null ? "" : out.toString();
    }

    @Nullable
    protected <T> String formatMsg(@Nullable Appendable writer, T ... templateAndArguments) throws IOException {
        if (Check.hasLength(templateAndArguments)) {
            String template = String.valueOf(templateAndArguments[0]);
            Object[] params = new Object[templateAndArguments.length - 1];
            System.arraycopy(templateAndArguments, 1, params, 0, params.length);
            return this.formatMsg(writer, template, (T[])params);
        }
        return null;
    }

    protected void writeValue(@Nullable Object value, @Nonnull Appendable out, boolean marked) throws IOException {
        Object val;
        Object object = val = value instanceof Supplier ? ((Supplier)value).get() : value;
        if (marked) {
            out.append(val != null ? val.toString() : String.valueOf(val));
        } else if (val instanceof Throwable) {
            out.append('\n');
            ((Throwable)val).printStackTrace(ObjectUtils.toPrintWriter(out));
        } else {
            out.append(' ');
            out.append(String.valueOf(val));
        }
    }

    @Nonnull
    public static <T> String format(@Nullable CharSequence messageTemplate, T ... arguments) {
        try {
            return new MsgFormatter().formatMsg(NO_WRITER, messageTemplate, arguments);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static <T> String format(T ... templateAndArguments) {
        try {
            return new MsgFormatter().formatMsg(NO_WRITER, templateAndArguments);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

