/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.Assert;

public class TextBuilder
implements CharSequence {
    public static final char NEW_LINE = '\n';
    @NotNull
    private final StringBuilder builder;

    public TextBuilder() {
        this(new StringBuilder());
    }

    public TextBuilder(StringBuilder builder) {
        this.builder = Assert.notNull(builder, "builder");
    }

    public TextBuilder add(CharSequence ... items) {
        for (CharSequence item : items) {
            this.builder.append(item);
        }
        return this;
    }

    public TextBuilder line(CharSequence ... items) {
        if (!this.endsByNewLine()) {
            this.builder.append('\n');
        }
        return this.add(items);
    }

    public TextBuilder emptyLine() {
        this.line(new CharSequence[0]);
        this.builder.append('\n');
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.builder.length() == 0;
    }

    protected final boolean endsByNewLine() {
        int length = this.builder.length();
        return length == 0 || this.builder.charAt(length - 1) == '\n';
    }

    public void writeTo(@NotNull Appendable writer) throws IOException {
        writer.append(this.builder);
    }

    @Override
    public final int length() {
        return this.builder.length();
    }

    @Override
    public final char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public final CharSequence subSequence(int from, int to) {
        return this.builder.subSequence(from, to);
    }

    @Override
    @NotNull
    public String toString() {
        return this.builder.toString();
    }
}

