/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.msg.MsgFormatter;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.config.Formatter;
import org.ujorm.tools.xml.config.XmlConfig;

public abstract class AbstractWriter {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String HTML_DOCTYPE = "<!DOCTYPE html>";
    public static final char XML_GT = '>';
    public static final char XML_LT = '<';
    public static final char XML_AMPERSAND = '&';
    public static final char XML_APOSTROPHE = '\'';
    public static final char XML_2QUOT = '\"';
    public static final char SPACE = ' ';
    public static final char NBSP = '\u00a0';
    public static final char FORWARD_SLASH = '/';
    public static final String CDATA_BEG = "<![CDATA[";
    public static final String CDATA_END = "]]>";
    public static final String COMMENT_BEG = "<!--";
    public static final String COMMENT_END = "-->";
    public static final MsgFormatter FORMATTER = new MsgFormatter(){};
    @NotNull
    protected final Appendable out;
    @NotNull
    protected final XmlConfig config;
    @NotNull
    private final Formatter formatter;
    protected final boolean indentationEnabled;
    @NotNull
    private final Appendable writerEscaped = new Appendable(){
        private final boolean attribute = false;

        @Override
        @NotNull
        public Appendable append(@NotNull CharSequence value) throws IOException {
            AbstractWriter.this.write(value, false);
            return this;
        }

        @Override
        @NotNull
        public Appendable append(@NotNull CharSequence value, int start, int end) throws IOException {
            AbstractWriter.this.write(value, start, end, false);
            return this;
        }

        @Override
        @NotNull
        public Appendable append(char value) throws IOException {
            AbstractWriter.this.write(value, false);
            return this;
        }
    };

    public AbstractWriter(@NotNull Appendable out, @NotNull XmlConfig config) {
        this.out = Assert.notNull(out, "out");
        this.config = Assert.notNull(config, "config");
        this.indentationEnabled = Check.hasLength(config.getIndentation());
        this.formatter = config.getFormatter();
    }

    public final void write(@NotNull CharSequence text, boolean attribute) throws IOException {
        this.write(text, 0, text.length(), attribute);
    }

    void write(@NotNull CharSequence text, int from, int max, boolean attribute) throws IOException {
        for (int i = from; i < max; ++i) {
            this.write(text.charAt(i), attribute);
        }
    }

    private void write(char c, boolean attribute) throws IOException {
        switch (c) {
            case '<': {
                this.out.append('&').append("lt;");
                break;
            }
            case '>': {
                this.out.append('&').append("gt;");
                break;
            }
            case '&': {
                this.out.append('&').append("amp;");
                break;
            }
            case '\"': {
                if (attribute) {
                    this.out.append('&').append("quot;");
                    break;
                }
                this.out.append(c);
                break;
            }
            case '\'': {
                this.out.append(c);
                break;
            }
            case ' ': {
                this.out.append(c);
                break;
            }
            case '\u00a0': {
                this.out.append('&').append("#160;");
                break;
            }
            default: {
                if (c > ' ') {
                    this.out.append(c);
                    break;
                }
                this.out.append('&').append("#");
                this.out.append(Integer.toString(c));
                this.out.append(";");
            }
        }
    }

    public void writeValue(@Nullable Object value, @NotNull ApiElement element, @Nullable String attributeName) throws IOException {
        this.write(this.formatter.format(value, element, attributeName), attributeName != null);
    }

    public final void writeRawValue(@NotNull CharSequence rawValue, @NotNull ApiElement element) throws IOException {
        this.out.append(rawValue);
    }

    public void writeNewLine(int level) throws IOException {
        this.out.append(this.config.getNewLine());
        if (this.indentationEnabled) {
            for (int i = level; i > 0; --i) {
                this.out.append(this.config.getIndentation());
            }
        }
    }

    public String toString() {
        return this.out.toString();
    }

    @NotNull
    public Appendable getWriter() {
        return this.out;
    }

    @NotNull
    public Appendable getWriterEscaped() {
        return this.writerEscaped;
    }

    @NotNull
    public static Appendable createWriter(@NotNull Object httpServletResponse, @NotNull Charset charset, boolean noCache) throws ReflectiveOperationException {
        Method setEncoding = httpServletResponse.getClass().getMethod("setCharacterEncoding", String.class);
        Method setHeader = httpServletResponse.getClass().getMethod("setHeader", String.class, String.class);
        Method getWriter = httpServletResponse.getClass().getMethod("getWriter", new Class[0]);
        setEncoding.invoke(httpServletResponse, charset.toString());
        setHeader.invoke(httpServletResponse, "Content-Type", "text/html; charset=" + charset);
        if (noCache) {
            setHeader.invoke(httpServletResponse, "Cache-Control", "no-cache, no-store, must-revalidate");
            setHeader.invoke(httpServletResponse, "Pragma", "no-cache");
            setHeader.invoke(httpServletResponse, "Expires", "0");
            setHeader.invoke(httpServletResponse, "X-UA-Compatible", "IE=edge");
        }
        Appendable writer = (Appendable)getWriter.invoke(httpServletResponse, new Object[0]);
        return writer;
    }
}

