/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.xml.config;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.xml.config.ApiInjector;
import org.ujorm.tools.xml.config.XmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;

public interface HtmlConfig
extends XmlConfig {
    @NotNull
    public CharSequence getTitle();

    @NotNull
    public CharSequence[] getCssLinks();

    @NotNull
    public Optional<CharSequence> getLanguage();

    @NotNull
    public String getContentType();

    public boolean isDocumentObjectModel();

    public boolean isHtmlHeaderRequest();

    @Deprecated
    @Nullable
    public CharSequence getRawHeaderText();

    @NotNull
    public ApiInjector getHeaderInjector();

    public String getRootElementName();

    default public DefaultHtmlConfig cloneForAjax() {
        DefaultHtmlConfig result = new DefaultHtmlConfig(this);
        result.setNiceFormat();
        result.setRootElementName("");
        result.setDoctype("");
        result.setHtmlHeader(false);
        result.setCacheAllowed(false);
        return result;
    }

    @NotNull
    public static DefaultHtmlConfig ofDefault() {
        return new DefaultHtmlConfig();
    }

    @NotNull
    public static DefaultHtmlConfig ofElementName(@Nullable String rootElementName) {
        return HtmlConfig.ofElement(rootElementName, true);
    }

    @NotNull
    public static DefaultHtmlConfig ofElement(@Nullable String rootElementName, boolean enabled) {
        DefaultHtmlConfig result = HtmlConfig.ofDefault();
        result.setRootElementName(enabled ? rootElementName : null);
        result.setHtmlHeader(false);
        result.setDoctype("");
        return result;
    }

    @NotNull
    public static DefaultHtmlConfig ofEmptyElement() {
        DefaultHtmlConfig result = HtmlConfig.ofElement("", false);
        result.setHtmlHeader(false);
        result.setDoctype("");
        result.setNewLine("");
        return result;
    }

    public static DefaultHtmlConfig of(@NotNull HtmlConfig htmlConfig) {
        return new DefaultHtmlConfig(htmlConfig);
    }
}

