/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.common.Joinable;
import org.ujorm.tools.common.StringUtils;

public abstract class StreamUtils {
    static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));

    private StreamUtils() {
    }

    @NotNull
    public Stream<String> rows(@NotNull String text) {
        return new BufferedReader(new CharArrayReader(text.toCharArray())).lines();
    }

    public static Stream<String> rowsOfUrl(@NotNull URL url) throws IOException {
        return StringUtils.readLines(url);
    }

    public static <T> Stream<T> toStream(@NotNull Iterator<T> iterator) {
        return StreamUtils.toStream(iterator, false);
    }

    public static <T> Stream<T> toStream(@NotNull Iterator<T> iterator, boolean parallel) {
        Iterable iterable = () -> iterator;
        return StreamSupport.stream(iterable.spliterator(), parallel);
    }

    @NotNull
    public static <T> Collector<T, ?, ArrayDeque<T>> collectToDequeue() {
        return Collectors.toCollection(ArrayDeque::new);
    }

    @NotNull
    public static <D, R> Joinable<D, R> toJoinable(@NotNull Function<D, R> fce) {
        return Joinable.of(fce);
    }
}

