/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Array<T>
implements Serializable {
    protected final T[] array;

    protected Array(@NotNull T[] array) {
        this.array = array;
    }

    @NotNull
    public final Array<T> clone() {
        return new Array<T>(this.toArray());
    }

    @NotNull
    public T[] toArray() {
        Class<?> type = this.array.getClass().getComponentType();
        Object[] result = (Object[])java.lang.reflect.Array.newInstance(type, this.array.length);
        System.arraycopy(this.array, 0, result, 0, this.array.length);
        return result;
    }

    @NotNull
    public List<T> toList() {
        return Arrays.asList(this.array);
    }

    @NotNull
    public Stream<T> stream() {
        return Stream.of(this.array);
    }

    @NotNull
    public Optional<T> get(int i) {
        int j = i >= 0 ? i : this.array.length + i;
        return Optional.ofNullable(j >= 0 && j < this.array.length ? (Object)this.array[j] : null);
    }

    public T getItem(int i) {
        return this.array[i >= 0 ? i : this.array.length + i];
    }

    @NotNull
    public Optional<T> getFirst() {
        return this.get(0);
    }

    @NotNull
    public Optional<T> getLast() {
        return this.get(-1);
    }

    public Array<T> removeFirst() {
        T[] result = this.array.length > 0 ? Arrays.copyOfRange(this.array, 1, this.array.length) : this.array;
        return new Array<T>(result);
    }

    @NotNull
    public Array<T> subArray(int from) {
        int from2 = from < 0 ? this.array.length - from : from;
        T[] result = Arrays.copyOfRange(this.array, Math.min(from2, this.array.length), this.array.length);
        return new Array<T>(result);
    }

    @NotNull
    public Array<T> add(T ... toAdd) {
        T[] result = Arrays.copyOf(this.array, this.array.length + toAdd.length);
        System.arraycopy(toAdd, 0, result, this.array.length, toAdd.length);
        return new Array<T>(result);
    }

    @NotNull
    public Array<T> add(@NotNull Array<T> toAdd) {
        return this.add(toAdd.array);
    }

    public boolean isEmpty() {
        return this.array.length == 0;
    }

    public int size() {
        return this.array.length;
    }

    public int hashCode() {
        return Arrays.hashCode(this.array);
    }

    public boolean equals(@NotNull Object obj) {
        return obj instanceof Array && Arrays.equals(this.array, ((Array)obj).array);
    }

    @NotNull
    public String toString() {
        return Arrays.asList(this.array).toString();
    }

    @NotNull
    public static <T> Array<T> of(T ... chars) {
        return new Array<T>(chars);
    }
}

