/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;

public class StringUtils {
    public static final String SEPARATOR = "/";
    private static final String NO_RESOURCE_MSG = "Resource is not available: ";
    @NotNull
    private final Charset charset;
    @NotNull
    private final Class<?> classOfLoader;

    public StringUtils() {
        this(StandardCharsets.UTF_8);
    }

    public StringUtils(@NotNull Charset charset) {
        this(charset, StringUtils.class);
    }

    public StringUtils(@NotNull Charset charset, @NotNull Class<?> classOfLoader) {
        this.charset = Assert.notNull(charset, "charset");
        this.classOfLoader = Assert.notNull(classOfLoader, "classOfLoader");
    }

    @NotNull
    public String readBody(String ... resource) {
        return this.readBody((Class<?>)null, resource);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public String readBody(@NotNull Class<?> basePackage, String ... resourcePath) {
        String resource = this.buildResource(basePackage, resourcePath);
        try (InputStream is = this.classOfLoader.getResourceAsStream(resource);){
            String string = this.readBody(is);
            return string;
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalStateException(NO_RESOURCE_MSG + resource, e);
        }
    }

    @NotNull
    public String readBody(@NotNull InputStream is) {
        return new BufferedReader(new InputStreamReader(is, this.charset)).lines().collect(Collectors.joining("\n"));
    }

    @NotNull
    public Stream<String> readRows(@Nullable Class<?> basePackage, String ... resourcePath) {
        String resource = this.buildResource(basePackage, resourcePath);
        try {
            return this.readRows(this.classOfLoader.getResource(resource));
        }
        catch (IOException | NullPointerException e) {
            throw new IllegalStateException(NO_RESOURCE_MSG + resource, e);
        }
    }

    @NotNull
    public Stream<String> readRows(@NotNull URL url) throws IOException {
        InputStream is = url.openStream();
        if (is == null) {
            throw new IllegalStateException("Can't open: " + url);
        }
        return (Stream)this.readRows(is).onClose(() -> {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't close: " + url, e);
            }
        });
    }

    @NotNull
    public Stream<String> readRows(@NotNull InputStream is) throws IOException {
        return new BufferedReader(new InputStreamReader(is, this.charset)).lines();
    }

    @NotNull
    public Stream<String> readRows(@NotNull Path file) throws IOException {
        return this.readRows(Files.newInputStream(file, new OpenOption[0]));
    }

    @NotNull
    public Stream<String> readRows(@NotNull File file) throws IOException {
        return this.readRows(new FileInputStream(file));
    }

    protected String buildResource(@Nullable Class<?> basePackage, String ... resourcePath) {
        String endPath = resourcePath.length == 1 ? resourcePath[0] : String.join((CharSequence)SEPARATOR, resourcePath);
        return endPath.startsWith(SEPARATOR) ? endPath : String.join((CharSequence)SEPARATOR, "", basePackage.getPackage().getName().replace('.', SEPARATOR.charAt(0)), endPath);
    }

    @NotNull
    public static String read(@NotNull Class<?> basePackage, String ... resourcePath) {
        return new StringUtils(StandardCharsets.UTF_8, basePackage).readBody(basePackage, resourcePath);
    }

    @NotNull
    public static String read(@NotNull InputStream is) {
        return new StringUtils().readBody(is);
    }

    @NotNull
    public static Stream<String> readLines(@NotNull URL url) throws IOException {
        return new StringUtils().readRows(url);
    }

    @NotNull
    public static Stream<String> readLines(@Nullable Class<?> basePackage, String ... resourcePath) {
        return new StringUtils(StandardCharsets.UTF_8, basePackage).readRows(basePackage, resourcePath);
    }

    @NotNull
    public static Stream<String> readLines(String ... resourcePath) {
        return StringUtils.readLines(StringUtils.class, resourcePath);
    }
}

