/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.set.LoopingIterator;

public class RowIterator
implements LoopingIterator<ResultSet> {
    @NotNull
    private final PreparedStatement ps;
    @Nullable
    private ResultSet rs;
    private boolean cursorReady = false;
    private boolean hasNext = false;

    public RowIterator(@NotNull PreparedStatement ps) {
        this.ps = ps;
    }

    @Override
    public boolean hasNext() throws IllegalStateException {
        if (!this.cursorReady) {
            try {
                if (this.rs == null) {
                    this.rs = this.ps.executeQuery();
                }
                this.hasNext = this.rs.next();
                if (!this.hasNext) {
                    this.close();
                }
                this.cursorReady = true;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.hasNext;
    }

    @Override
    public ResultSet next() {
        if (this.hasNext()) {
            this.cursorReady = false;
            return this.rs;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() {
        if (this.rs != null) {
            try (PreparedStatement tempPs = this.ps;
                 ResultSet tempRs = this.rs;){
                this.cursorReady = true;
                this.hasNext = false;
            }
            catch (SQLException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

