/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.msg;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.common.ObjectUtils;

public final class MessageArg<T>
implements Serializable,
CharSequence {
    public static final String PARAM_BEG = "${";
    public static final char PARAM_END = '}';
    @NotNull
    private final String name;
    @Nullable
    private final String format;
    @NotNull
    private final String code;

    public MessageArg(@NotNull String name) {
        this(name, null);
    }

    public MessageArg(@NotNull String name, @Nullable String format) {
        Assert.notNull(name, "Name is required", name);
        Assert.isTrue(name.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), name);
        Assert.isTrue(format == null || format.indexOf(125) < 0, "Forbidden character {} in argument {}", Character.valueOf('}'), format);
        this.name = name;
        this.format = format;
        this.code = this.toCode();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String name() {
        return this.name;
    }

    @Nullable
    public String getFormat() {
        return this.format;
    }

    @NotNull
    public String getCode() {
        return this.code;
    }

    @NotNull
    private String toCode() {
        StringBuilder result = new StringBuilder(PARAM_BEG.length() + 1 + this.name.length() + (this.format != null ? this.format.length() + 1 : 0));
        result.append(PARAM_BEG).append(this.name);
        if (Check.hasLength(this.format)) {
            result.append(',').append(this.format);
        }
        result.append('}');
        return result.toString();
    }

    public <T> T getValue(Map<String, Object> map) {
        return (T)map.get(this.name);
    }

    @Override
    public String toString() {
        return this.getCode();
    }

    @Override
    public int length() {
        return this.getCode().length();
    }

    @Override
    public char charAt(int index) {
        return this.getCode().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.getCode().subSequence(start, end);
    }

    public boolean equals(Object obj) {
        return this == obj || ObjectUtils.check(obj, MessageArg.class, v -> Objects.equals(this.name, v.name) && Objects.equals(this.format, v.format));
    }

    public static <T> MessageArg<T> of(@NotNull String name) {
        return new MessageArg<T>(name);
    }

    public static <T> MessageArg<T> of(@NotNull String name, @Nullable String format) {
        return new MessageArg<T>(name, format);
    }
}

