/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.sql;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.ujorm.tools.Assert;
import org.ujorm.tools.jdbc.JdbcBuilder;

public class SqlBuilder
extends JdbcBuilder {
    public SqlBuilder() {
    }

    public SqlBuilder(List<CharSequence> sql, List<Object> arguments) {
        super(sql, arguments);
    }

    public SqlBuilder select(CharSequence ... columns) {
        super.write("SELECT");
        for (CharSequence column : columns) {
            super.column(column);
        }
        return this;
    }

    public SqlBuilder from(CharSequence ... tables) {
        super.write("FROM");
        for (CharSequence table : tables) {
            super.write(table);
        }
        return this;
    }

    public SqlBuilder where() {
        super.write("WHERE");
        return this;
    }

    public SqlBuilder insert(@NotNull CharSequence table) {
        Assert.hasLength(table, "table");
        super.write("INSERT INTO");
        super.write(table);
        return this;
    }

    public SqlBuilder update(@NotNull CharSequence table) {
        Assert.hasLength(table, "table");
        super.write("UPDATE");
        super.write(table);
        super.write("SET");
        return this;
    }

    public SqlBuilder delete(@NotNull CharSequence table) {
        Assert.hasLength(table, "table");
        super.write("DELETE");
        super.write("FROM");
        super.write(table);
        super.write("SET");
        return this;
    }

    @Override
    public SqlBuilder addArguments(Object ... values) {
        return (SqlBuilder)super.addArguments(values);
    }

    @Override
    protected SqlBuilder addValue(Object value) {
        return (SqlBuilder)super.addValue(value);
    }

    @Override
    public SqlBuilder value(Object value) {
        return (SqlBuilder)super.value(value);
    }

    @Override
    public SqlBuilder condition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.condition(sqlCondition, operator, value);
    }

    @Override
    public SqlBuilder orCondition(CharSequence sqlCondition, String operator, Object ... values) {
        return (SqlBuilder)super.orCondition(sqlCondition, operator, values);
    }

    @Override
    public SqlBuilder orCondition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.orCondition(sqlCondition, operator, value);
    }

    @Override
    public SqlBuilder andCondition(CharSequence sqlCondition, String operator, Object ... values) {
        return (SqlBuilder)super.andCondition(sqlCondition, operator, values);
    }

    @Override
    public SqlBuilder andCondition(CharSequence sqlCondition, String operator, Object value) {
        return (SqlBuilder)super.andCondition(sqlCondition, operator, value);
    }

    @Override
    public SqlBuilder columnInsert(CharSequence column, Object value) {
        return (SqlBuilder)super.columnInsert(column, value);
    }

    @Override
    public SqlBuilder columnUpdate(CharSequence column, Object value) {
        return (SqlBuilder)super.columnUpdate(column, value);
    }

    @Override
    public final SqlBuilder column(CharSequence column) {
        return (SqlBuilder)super.column(column);
    }

    @Override
    public final SqlBuilder writeManyNoSpace(CharSequence ... sqlFragments) {
        return (SqlBuilder)super.writeManyNoSpace(sqlFragments);
    }

    @Override
    public final SqlBuilder writeMany(CharSequence ... sqlFragments) {
        return (SqlBuilder)super.writeMany(sqlFragments);
    }

    @Override
    public final SqlBuilder writeNoSpace(CharSequence sqlFragment) {
        return (SqlBuilder)super.writeNoSpace(sqlFragment);
    }

    @Override
    public final SqlBuilder write(CharSequence sqlFragment) {
        return (SqlBuilder)super.write(sqlFragment);
    }

    public final SqlBuilder write(SqlBuilder builder) {
        return (SqlBuilder)super.write(builder);
    }
}

