/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.ujorm.tools.jdbc.SqlConsumer;
import org.ujorm.tools.jdbc.SqlFunction;

public class SqlParamBuilder
implements AutoCloseable {
    private static final Pattern SQL_MARK = Pattern.compile(":(\\w+)");
    @NotNull
    protected final Connection dbConnection;
    @Nullable
    protected String sqlTemplate;
    @NotNull
    protected final Map<String, Object> params = new HashMap<String, Object>();
    @Nullable
    private PreparedStatement preparedStatement = null;

    public SqlParamBuilder(@NotNull Connection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public SqlParamBuilder sql(String ... sqlLines) {
        this.close();
        this.params.clear();
        this.sqlTemplate = sqlLines.length == 1 ? sqlLines[0] : String.join((CharSequence)"\n", sqlLines);
        return this;
    }

    public SqlParamBuilder bind(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    public SqlParamBuilder bind(@NotNull String key, Object ... value) {
        return this.bind(key, (Object)Arrays.asList(value));
    }

    public int execute() throws IllegalStateException, SQLException {
        return this.prepareStatement().executeUpdate();
    }

    @NotNull
    private ResultSet executeSelect() throws IllegalStateException {
        try {
            return this.prepareStatement().executeQuery();
        }
        catch (Exception ex) {
            throw ex instanceof RuntimeException ? (RuntimeException)ex : new IllegalStateException(ex);
        }
    }

    @NotNull
    private Stream<ResultSet> stream() {
        final ResultSet resultSet = this.executeSelect();
        Iterator<ResultSet> iterator = new Iterator<ResultSet>(){

            @Override
            public boolean hasNext() {
                try {
                    return resultSet.next();
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }

            @Override
            public ResultSet next() {
                return resultSet;
            }
        };
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
    }

    public void forEach(@NotNull SqlConsumer consumer) throws IllegalStateException, SQLException {
        this.stream().forEach(consumer);
    }

    @NotNull
    public <R> Stream<R> streamMap(SqlFunction<ResultSet, ? extends R> mapper) {
        return this.stream().map(mapper);
    }

    public Connection getConnection() {
        return this.dbConnection;
    }

    @Override
    public void close() {
        try {
            PreparedStatement c2 = this.preparedStatement;
            Throwable throwable = null;
            if (c2 != null) {
                if (throwable != null) {
                    try {
                        c2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    c2.close();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Closing fails", e);
        }
        finally {
            this.preparedStatement = null;
        }
    }

    @NotNull
    public PreparedStatement prepareStatement() throws SQLException {
        ArrayList<Object> sqlValues = new ArrayList<Object>(this.params.size());
        String sql = this.buildSql(sqlValues, false);
        PreparedStatement result = this.preparedStatement != null ? this.preparedStatement : this.dbConnection.prepareStatement(sql);
        int max = sqlValues.size();
        for (int i = 0; i < max; ++i) {
            result.setObject(i + 1, sqlValues.get(i));
        }
        this.preparedStatement = result;
        return result;
    }

    @NotNull
    protected String buildSql(@NotNull List<Object> sqlValues, boolean toLog) {
        StringBuffer result = new StringBuffer(256);
        Matcher matcher = SQL_MARK.matcher(this.sqlTemplate);
        HashSet<String> missingKeys = new HashSet<String>();
        Object[] singleValue = new Object[1];
        while (matcher.find()) {
            String key = matcher.group(1);
            Object value = this.params.get(key);
            if (value != null) {
                matcher.appendReplacement(result, "");
                singleValue[0] = value;
                Object[] values = value instanceof List ? ((List)value).toArray() : singleValue;
                for (int i = 0; i < values.length; ++i) {
                    if (i > 0) {
                        result.append(',');
                    }
                    result.append(Matcher.quoteReplacement(toLog ? "[" + values[i] + "]" : "?"));
                    sqlValues.add(values[i]);
                }
                continue;
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(":" + key));
            missingKeys.add(key);
        }
        if (!toLog && !missingKeys.isEmpty()) {
            throw new IllegalArgumentException("Missing value of the keys: " + missingKeys);
        }
        matcher.appendTail(result);
        return result.toString();
    }

    @NotNull
    public SqlParamBuilder setParam(String key, Object value) {
        this.params.put(key, value);
        return this;
    }

    @NotNull
    public String sqlTemplate() {
        return this.sqlTemplate;
    }

    @NotNull
    public String toString() {
        return this.buildSql(new ArrayList<Object>(), true);
    }
}

