/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.Assert;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.xml.AbstractElement;
import org.ujorm.tools.xml.config.HtmlConfig;
import org.ujorm.tools.xml.config.impl.DefaultHtmlConfig;
import org.ujorm.tools.xml.dom.XmlElement;
import org.ujorm.tools.xml.dom.XmlWriter;

public class HtmlPage
extends Element {
    @Nonnull
    private Element head;
    @Nonnull
    private Element body;
    @Nonnull
    private final HtmlConfig config;
    @Nonnull
    private final Writer writer;

    public HtmlPage(@Nonnull HtmlConfig config, @Nonnull Writer writer) {
        super((AbstractElement)new XmlElement((CharSequence)"html"));
        this.config = config;
        this.writer = writer;
    }

    public <T extends Element> T getHead() {
        if (this.head == null) {
            this.head = this.addElement("head");
        }
        return (T)this.head;
    }

    @Nonnull
    public <T extends Element> T getBody() {
        if (this.body == null) {
            this.body = this.addElement("body");
        }
        return (T)this.body;
    }

    public void addJavascriptLinks(boolean defer, CharSequence ... javascriptLinks) {
        for (CharSequence js : javascriptLinks) {
            this.addJavascriptLink(defer, js);
        }
    }

    public <T extends Element> T addJavascriptLink(boolean defer, @Nonnull CharSequence javascriptLink) {
        Assert.notNull((Object)javascriptLink, (Object[])new String[]{"The argument {} is required", "javascriptLink"});
        return (T)((Element)this.getHead()).addElement("script").setAttrib("src", javascriptLink).setAttrib("defer", defer ? "defer" : null).addText((Object)"");
    }

    public <T extends Element> T addJavascriptContents(@Nonnull CharSequence javascript) {
        Assert.notNull((Object)javascript, (Object[])new String[]{"The argument {} is required", "javascript"});
        return (T)((Element)this.getHead()).addElement("script").setAttrib("language", "javascript").setAttrib("type", "text/javascript").addText((Object)javascript);
    }

    public void addCssLinks(CharSequence ... css) {
        for (CharSequence cssLink : css) {
            this.addCssLink(cssLink);
        }
    }

    public <T extends Element> T addCssLink(@Nonnull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return (T)((Element)this.getHead()).addElement("link").setAttrib("href", css).setAttrib("rel", "stylesheet");
    }

    public <T extends Element> T addCssBody(@Nonnull CharSequence css) {
        Assert.notNull((Object)css, (Object[])new String[]{"The argument {} is required", "css"});
        return (T)((Element)this.getHead()).addElement("style").addRawText(css);
    }

    @Override
    @Nonnull
    public String toString() throws IllegalStateException {
        return this.writer.toString();
    }

    @Override
    public void close() throws IllegalStateException {
        super.close();
        if (this.origElement instanceof XmlElement) {
            try {
                XmlWriter xmlWriter = new XmlWriter((Appendable)this.writer.append(this.config.getDoctype()).append('\n'), this.config.getIndentation());
                XmlElement xmlElement = (XmlElement)this.origElement;
                xmlElement.toWriter(this.config.getFirstLevel() + 1, xmlWriter);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Nonnull
    public HtmlConfig getConfig() {
        return this.config;
    }

    public CharSequence getTitle() {
        return this.getConfig().getTitle();
    }

    @Nonnull
    public static HtmlPage of(@Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        return HtmlPage.of(response, (HtmlConfig)HtmlConfig.ofDefault());
    }

    @Nonnull
    public static HtmlPage of(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlPage.of(response, (HtmlConfig)config);
    }

    @Nonnull
    public static HtmlPage of(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, @Nonnull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlPage.of(response, (HtmlConfig)config);
    }

    @Nonnull
    public static HtmlPage niceOf(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat(true);
        config.setTitle(title);
        config.setCssLinks(cssLinks);
        return HtmlPage.of(response, (HtmlConfig)config);
    }

    @Nonnull
    public static HtmlPage niceOf(@Nonnull CharSequence title, @Nonnull HttpServletResponse response, @Nonnull Charset charset, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat(true);
        config.setTitle(title);
        config.setCharset(charset);
        config.setCssLinks(cssLinks);
        return HtmlPage.of(response, (HtmlConfig)config);
    }

    @Nonnull
    public static HtmlPage niceOf(@Nonnull HttpServletResponse response, CharSequence ... cssLinks) {
        DefaultHtmlConfig config = HtmlConfig.ofDefault();
        config.setNiceFormat(true);
        config.setCssLinks(cssLinks);
        return HtmlPage.of(response, (HtmlConfig)config);
    }

    @Nonnull
    public static HtmlPage of(@Nonnull HttpServletResponse response, @Nonnull HtmlConfig config) throws IllegalStateException {
        response.setCharacterEncoding(config.getCharset().toString());
        try {
            HtmlPage result = new HtmlPage(config, response.getWriter());
            config.getLanguage().ifPresent(lang -> result.setAttrib("lang", lang));
            ((Element)result.getHead()).addElement("meta").setAttrib("charset", config.getCharset());
            ((Element)result.getHead()).addElement("title").addText((Object)config.getTitle());
            result.addCssLinks(config.getCssLinks());
            return result;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nonnull
    public static HtmlPage of(@Nullable HtmlConfig config) throws IllegalStateException {
        if (config == null) {
            config = new DefaultHtmlConfig();
        }
        HtmlPage result = new HtmlPage(config, new CharArrayWriter(256));
        config.getLanguage().ifPresent(lang -> result.setAttrib("lang", lang));
        ((Element)result.getHead()).addElement("meta").setAttrib("charset", config.getCharset());
        ((Element)result.getHead()).addElement("title").addText((Object)config.getTitle());
        result.addCssLinks(config.getCssLinks());
        return result;
    }
}

