/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Html;
import org.ujorm.tools.xml.AbstractElement;
import org.ujorm.tools.xml.dom.XmlElement;

public class Element
extends AbstractElement<Element>
implements Html {
    protected final AbstractElement origElement;

    public Element(@Nonnull AbstractElement original) {
        super((CharSequence)original.getName());
        this.origElement = original;
    }

    @Nonnull
    public final <T extends Element> T addElement(@Nonnull String name) throws IllegalStateException {
        try {
            return (T)new Element(this.origElement.addElement(name));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final <T extends Element> T setAttrib(@Nonnull String name, @Nullable Object value) {
        try {
            this.origElement.setAttrib(name, value);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Element> T addText(Object data) throws IllegalStateException {
        try {
            this.origElement.addText(data);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Element> T addText(Object ... data) throws IllegalStateException {
        return this.addTextSeparted("", data);
    }

    public <T extends Element> T addTextSeparted(@Nonnull Object separator, Object ... data) throws IllegalStateException {
        try {
            int max = data.length;
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    this.origElement.addText(separator);
                }
                this.origElement.addText(data[i]);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return (T)this;
    }

    public <T extends Element> T addRawText(Object data) throws IllegalStateException {
        try {
            this.origElement.addRawText(data);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Element> T addComment(CharSequence comment) throws IllegalStateException {
        try {
            this.origElement.addComment(comment);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Element> T addCDATA(CharSequence charData) throws IllegalStateException {
        try {
            this.origElement.addCDATA(charData);
            return (T)this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void close() throws IllegalStateException {
        try {
            this.origElement.close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T extends Element> T addElement(@Nonnull String name, CharSequence ... cssClasses) {
        return this.addElement(name).setClass(cssClasses);
    }

    public <T extends Element> T addTable(CharSequence ... cssClasses) {
        return (T)((Element)this.addElement("table", cssClasses)).setAttrib("cellpadding", 0).setAttrib("cellspacing", 0);
    }

    public <T extends Element> T addTable(Object[][] data, CharSequence ... cssClass) {
        return this.addTable(Arrays.asList(data), cssClass);
    }

    public <T extends Element> T addTable(List<Object[]> data, CharSequence ... cssClass) {
        T result = this.addTable(cssClass);
        if (Check.hasLength((Object[])cssClass)) {
            ((Element)result).setAttrib("class", String.join((CharSequence)" ", cssClass));
        }
        for (Object[] rowValue : data) {
            AbstractElement rowElement = ((Element)result).addElement("tr");
            for (Object value : rowValue) {
                rowElement.addElement("td").addText(value);
            }
        }
        return result;
    }

    public <T extends Element> T addBody(CharSequence ... cssClasses) {
        return this.addElement("body", cssClasses);
    }

    public <T extends Element> T addTitle(CharSequence ... cssClasses) {
        return this.addElement("title", cssClasses);
    }

    public <T extends Element> T addLink(CharSequence ... cssClasses) {
        return this.addElement("link", cssClasses);
    }

    public <T extends Element> T addStyle(CharSequence ... cssClasses) {
        return this.addElement("style", cssClasses);
    }

    public <T extends Element> T addScript(CharSequence ... cssClasses) {
        return this.addElement("script", cssClasses);
    }

    public <T extends Element> T addDiv(CharSequence ... cssClasses) {
        return this.addElement("div", cssClasses);
    }

    public <T extends Element> T addFieldset(@Nullable String title, CharSequence ... cssClasses) {
        T result = this.addElement("fieldset", cssClasses);
        if (Check.hasLength((CharSequence)title)) {
            ((Element)result).addElement("legend").addText((Object)title);
        }
        return result;
    }

    public <T extends Element> T addPreformatted(CharSequence ... cssClasses) {
        return this.addElement("pre", cssClasses);
    }

    public <T extends Element> T addSpan(CharSequence ... cssClasses) {
        return this.addElement("span", cssClasses);
    }

    public <T extends Element> T addParagraph(CharSequence ... cssClasses) {
        return this.addElement("p", cssClasses);
    }

    public <T extends Element> T addForm(CharSequence ... cssClasses) {
        return this.addElement("form", cssClasses);
    }

    public <T extends Element> T addHeading(@Nonnull CharSequence title, CharSequence ... cssClasses) {
        return this.addHeading(1, title, cssClasses);
    }

    public <T extends Element> T addHeading(int level, @Nonnull CharSequence title, CharSequence ... cssClasses) {
        Assert.isTrue((level > 0 ? 1 : 0) != 0, (Object[])new Serializable[]{"Unsupported level {}", Integer.valueOf(level)});
        return (T)((Element)this.addElement("h" + level, cssClasses)).addText((Object)title);
    }

    public <T extends Element> T addTableHead(CharSequence ... cssClasses) {
        return this.addElement("thead", cssClasses);
    }

    public <T extends Element> T addTableRow(CharSequence ... cssClasses) {
        return this.addElement("tr", cssClasses);
    }

    public <T extends Element> T addTableDetail(CharSequence ... cssClasses) {
        return this.addElement("td", cssClasses);
    }

    public <T extends Element> T addLabel(CharSequence ... cssClasses) {
        return this.addElement("label", cssClasses);
    }

    public <T extends Element> T addInput(CharSequence ... cssClasses) {
        return this.addElement("input", cssClasses);
    }

    public <T extends Element> T addTextInput(CharSequence ... cssClasses) {
        return ((Element)this.addInput(cssClasses)).setType("text");
    }

    public <T extends Element> T addPasswordInput(CharSequence ... cssClasses) {
        return ((Element)this.addInput(cssClasses)).setType("password");
    }

    public <T extends Element> T addTextArea(CharSequence ... cssClasses) {
        return this.addElement("textarea", cssClasses);
    }

    public <T extends Element> T addSelect(CharSequence ... cssClasses) {
        return this.addElement("select", cssClasses);
    }

    public <T extends Element> T addSelectOptions(@Nonnull Object value, @Nonnull Map<?, ?> options, CharSequence ... cssClasses) {
        for (Object key : options.keySet()) {
            this.addElement("option").setAttrib("value", key).setAttrib("selected", Objects.equals(value, key) ? "selected" : null).addText(options.get(key));
        }
        return (T)this;
    }

    public <T extends Element> T addOption(CharSequence ... cssClasses) {
        return this.addElement("option", cssClasses);
    }

    public <T extends Element> T addButton(CharSequence ... cssClasses) {
        return this.addElement("button", cssClasses);
    }

    public <T extends Element> T addSubmitButton(CharSequence ... cssClasses) {
        T result = this.addButton(cssClasses);
        return ((Element)result).setType("submit");
    }

    public <T extends Element> T addAnchor(@Nonnull String url, CharSequence ... cssClasses) {
        T result = this.addElement("a", cssClasses);
        return ((Element)result).setHref(url);
    }

    public <T extends Element> T addAnchoredText(@Nonnull String url, Object ... text) {
        return ((Element)this.addElement("a").setHref(url)).addText(text);
    }

    public <T extends Element> T addUnorderedlist(CharSequence ... cssClasses) {
        return this.addElement("ul", cssClasses);
    }

    public <T extends Element> T addOrderedList(CharSequence ... cssClasses) {
        return this.addElement("ol", cssClasses);
    }

    public <T extends Element> T addListItem(CharSequence ... cssClasses) {
        return this.addElement("li", cssClasses);
    }

    public <T extends Element> T setClass(CharSequence ... cssClasses) {
        if (Check.hasLength((Object[])cssClasses)) {
            StringJoiner builder = new StringJoiner(" ");
            for (CharSequence cssClass : cssClasses) {
                if (!Check.hasLength((CharSequence)cssClass)) continue;
                builder.add(cssClass);
            }
            String result = builder.toString();
            if (Check.hasLength((CharSequence)result)) {
                this.setAttrib("class", result);
            }
        }
        return (T)this;
    }

    public <T extends Element> T addBreak(CharSequence ... cssClasses) {
        return this.addElement("br", cssClasses);
    }

    @Deprecated
    public <T extends Element> T setCellPadding(int value) {
        this.setAttrib("cellpadding", value);
        return (T)this;
    }

    @Deprecated
    public <T extends Element> T setCellSpacing(int value) {
        this.setAttrib("cellspacing", value);
        return (T)this;
    }

    public static Element createHtmlRoot(@Nonnull Object title, CharSequence ... cssLinks) {
        return Element.createHtmlRoot(title, null, cssLinks);
    }

    public static Element createHtmlRoot(@Nonnull Object title, @Nullable Charset charset, CharSequence ... cssLinks) {
        XmlElement result = new XmlElement((CharSequence)"html");
        XmlElement head = result.addElement("head");
        head.addElement("meta").setAttrib("charset", (Object)charset);
        head.addElement("title").addText(title);
        if (cssLinks != null) {
            for (CharSequence cssLink : cssLinks) {
                head.addElement("link").setAttrib("href", (Object)cssLink).setAttrib("rel", (Object)"stylesheet");
            }
        }
        return new Element((AbstractElement)result);
    }

    public <T extends Element> T setId(@Nullable CharSequence value) {
        this.setAttrib("id", value);
        return (T)this;
    }

    public <T extends Element> T setMethod(@Nullable Object value) {
        this.setAttrib("method", value);
        return (T)this;
    }

    public <T extends Element> T setAction(@Nullable Object value) {
        this.setAttrib("action", value);
        return (T)this;
    }

    public <T extends Element> T setType(@Nullable Object value) {
        this.setAttrib("type", value);
        return (T)this;
    }

    public <T extends Element> T setName(@Nullable CharSequence value) {
        this.setAttrib("name", value);
        return (T)this;
    }

    public <T extends Element> T setValue(@Nullable Object value) {
        this.setAttrib("value", value);
        return (T)this;
    }

    public <T extends Element> T setFor(@Nullable CharSequence value) {
        this.setAttrib("value", value);
        return (T)this;
    }

    public <T extends Element> T setRows(@Nullable int value) {
        this.setAttrib("rows", value);
        return (T)this;
    }

    public <T extends Element> T setCols(@Nullable Object value) {
        this.setAttrib("cols", value);
        return (T)this;
    }

    public <T extends Element> T setColSpan(@Nullable int value) {
        this.setAttrib("colspan", value);
        return (T)this;
    }

    public <T extends Element> T setRowSpan(@Nullable int value) {
        this.setAttrib("cols", value);
        return (T)this;
    }

    public <T extends Element> T setHref(@Nullable CharSequence value) {
        this.setAttrib("href", value);
        return (T)this;
    }

    public String toString() {
        return this.origElement.toString();
    }
}

