/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Html;
import org.ujorm.tools.xml.ApiElement;
import org.ujorm.tools.xml.model.XmlModel;

public final class Element
implements ApiElement<Element>,
Html {
    protected final ApiElement internalElement;

    public Element(@Nonnull ApiElement original) {
        this.internalElement = original;
    }

    @Nonnull
    public String getName() {
        return this.internalElement.getName();
    }

    @Nonnull
    public final Element setAttribute(@Nonnull String name, @Nullable Object value) {
        this.internalElement.setAttribute(name, value);
        return this;
    }

    @Nonnull
    public final Element setAttrib(@Nonnull String name, @Nullable Object value) {
        return this.setAttribute(name, value);
    }

    @Nonnull
    public Element addText(Object data) throws IllegalStateException {
        this.internalElement.addText(data);
        return this;
    }

    @Nonnull
    public Element addText(Object ... data) throws IllegalStateException {
        return this.addTextSeparted("", data);
    }

    @Nonnull
    public Element addTemplate(@Nonnull String template, Object ... data) throws IllegalStateException {
        return this.addText((Object)String.format(Locale.ENGLISH, template, data));
    }

    public Element addTextSeparted(@Nonnull Object separator, Object ... data) throws IllegalStateException {
        int max = data.length;
        for (int i = 0; i < max; ++i) {
            if (i > 0) {
                this.internalElement.addText(separator);
            }
            this.internalElement.addText(data[i]);
        }
        return this;
    }

    @Nonnull
    public Element addRawText(Object data) throws IllegalStateException {
        this.internalElement.addRawText(data);
        return this;
    }

    @Nonnull
    public Element addComment(CharSequence comment) throws IllegalStateException {
        this.internalElement.addComment(comment);
        return this;
    }

    @Nonnull
    public Element addCDATA(CharSequence charData) throws IllegalStateException {
        this.internalElement.addCDATA(charData);
        return this;
    }

    @Nonnull
    public void close() throws IllegalStateException {
        this.internalElement.close();
    }

    @Nonnull
    public Element addElement(@Nonnull String name) throws IllegalStateException {
        return new Element(this.internalElement.addElement(name));
    }

    @Nonnull
    public final Element addElement(@Nonnull String name, CharSequence ... cssClasses) {
        return this.addElement(name).setClass(cssClasses);
    }

    @Nonnull
    public Element addTable(CharSequence ... cssClasses) {
        return this.addElement("table", cssClasses);
    }

    @Deprecated
    @Nonnull
    public Element addTableNoSpaces(CharSequence ... cssClasses) {
        return this.addTable(cssClasses).setAttribute("cellpadding", 0).setAttribute("cellspacing", 0);
    }

    @Nonnull
    public Element addTable(Object[][] data, CharSequence ... cssClass) {
        return this.addTable(Arrays.asList(data), cssClass);
    }

    @Nonnull
    public Element addTable(List<Object[]> data, CharSequence ... cssClass) {
        Element result = this.addTable(cssClass);
        for (Object[] rowValue : data) {
            Element rowElement = result.addElement("tr");
            for (Object value : rowValue) {
                rowElement.addElement("td").addText(value);
            }
        }
        return result;
    }

    @Nonnull
    public Element addBody(CharSequence ... cssClasses) {
        return this.addElement("body", cssClasses);
    }

    @Nonnull
    public Element addTitle(CharSequence ... cssClasses) {
        return this.addElement("title", cssClasses);
    }

    @Nonnull
    public Element addLink(CharSequence ... cssClasses) {
        return this.addElement("link", cssClasses);
    }

    @Nonnull
    public Element addStyle(CharSequence ... cssClasses) {
        return this.addElement("style", cssClasses);
    }

    @Nonnull
    public Element addScript(CharSequence ... cssClasses) {
        return this.addElement("script", cssClasses);
    }

    @Nonnull
    public Element addDiv(CharSequence ... cssClasses) {
        return this.addElement("div", cssClasses);
    }

    @Nonnull
    public Element addFieldset(@Nullable String title, CharSequence ... cssClasses) {
        Element result = this.addElement("fieldset", cssClasses);
        if (Check.hasLength((CharSequence)title)) {
            result.addElement("legend").addText((Object)title);
        }
        return result;
    }

    @Nonnull
    public Element addPreformatted(CharSequence ... cssClasses) {
        return this.addElement("pre", cssClasses);
    }

    @Nonnull
    public Element addSpan(CharSequence ... cssClasses) {
        return this.addElement("span", cssClasses);
    }

    @Nonnull
    public Element addParagraph(CharSequence ... cssClasses) {
        return this.addElement("p", cssClasses);
    }

    @Nonnull
    public Element addForm(CharSequence ... cssClasses) {
        return this.addElement("form", cssClasses);
    }

    @Nonnull
    public Element addHeading(@Nonnull CharSequence title, CharSequence ... cssClasses) {
        return this.addHeading(1, title, cssClasses);
    }

    @Nonnull
    public Element addHeading(int level, @Nonnull CharSequence title, CharSequence ... cssClasses) {
        Assert.isTrue((level > 0 ? 1 : 0) != 0, (Object[])new Serializable[]{"Unsupported level {}", Integer.valueOf(level)});
        return this.addElement("h" + level, cssClasses).addText((Object)title);
    }

    @Nonnull
    public Element addTableHead(CharSequence ... cssClasses) {
        return this.addElement("thead", cssClasses);
    }

    @Nonnull
    public Element addTableRow(CharSequence ... cssClasses) {
        return this.addElement("tr", cssClasses);
    }

    @Nonnull
    public Element addTableDetail(CharSequence ... cssClasses) {
        return this.addElement("td", cssClasses);
    }

    @Nonnull
    public Element addLabel(CharSequence ... cssClasses) {
        return this.addElement("label", cssClasses);
    }

    @Nonnull
    public Element addInput(CharSequence ... cssClasses) {
        return this.addElement("input", cssClasses);
    }

    @Nonnull
    public Element addTextInput(CharSequence ... cssClasses) {
        return this.addInput(cssClasses).setType("text");
    }

    @Nonnull
    public Element addPasswordInput(CharSequence ... cssClasses) {
        return this.addInput(cssClasses).setType("password");
    }

    @Nonnull
    public Element addTextArea(CharSequence ... cssClasses) {
        return this.addElement("textarea", cssClasses);
    }

    @Nonnull
    public Element addSelect(CharSequence ... cssClasses) {
        return this.addElement("select", cssClasses);
    }

    @Nonnull
    public Element addSelectOptions(@Nonnull Object value, @Nonnull Map<?, ?> options, CharSequence ... cssClasses) {
        for (Object key : options.keySet()) {
            this.addElement("option").setAttribute("value", key).setAttribute("selected", Objects.equals(value, key) ? "selected" : null).addText(options.get(key));
        }
        return this;
    }

    @Nonnull
    public Element addOption(CharSequence ... cssClasses) {
        return this.addElement("option", cssClasses);
    }

    @Nonnull
    public Element addButton(CharSequence ... cssClasses) {
        return this.addElement("button", cssClasses);
    }

    @Nonnull
    public Element addSubmitButton(CharSequence ... cssClasses) {
        Element result = this.addButton(cssClasses);
        return result.setType("submit");
    }

    @Nonnull
    public Element addAnchor(@Nonnull String url, CharSequence ... cssClasses) {
        Element result = this.addElement("a", cssClasses);
        return result.setHref(url);
    }

    @Nonnull
    public Element addAnchoredText(@Nonnull String url, Object ... text) {
        return this.addElement("a").setHref(url).addText(text);
    }

    @Nonnull
    public Element addUnorderedlist(CharSequence ... cssClasses) {
        return this.addElement("ul", cssClasses);
    }

    @Nonnull
    public Element addOrderedList(CharSequence ... cssClasses) {
        return this.addElement("ol", cssClasses);
    }

    @Nonnull
    public Element addListItem(CharSequence ... cssClasses) {
        return this.addElement("li", cssClasses);
    }

    @Nonnull
    public Element setClass(CharSequence ... cssClasses) {
        if (Check.hasLength((Object[])cssClasses)) {
            StringJoiner builder = new StringJoiner(" ");
            for (CharSequence cssClass : cssClasses) {
                if (!Check.hasLength((CharSequence)cssClass)) continue;
                builder.add(cssClass);
            }
            String result = builder.toString();
            if (Check.hasLength((CharSequence)result)) {
                this.setAttribute("class", result);
            }
        }
        return this;
    }

    @Nonnull
    public Element addBreak(CharSequence ... cssClasses) {
        return this.addElement("br", cssClasses);
    }

    @Deprecated
    @Nonnull
    public Element setCellPadding(int value) {
        this.setAttribute("cellpadding", value);
        return this;
    }

    @Deprecated
    @Nonnull
    public Element setCellSpacing(int value) {
        this.setAttribute("cellspacing", value);
        return this;
    }

    @Nonnull
    public static Element createHtmlRoot(@Nonnull Object title, CharSequence ... cssLinks) {
        return Element.createHtmlRoot(title, null, cssLinks);
    }

    @Nonnull
    public static Element createHtmlRoot(@Nonnull Object title, @Nullable Charset charset, CharSequence ... cssLinks) {
        XmlModel result = new XmlModel((CharSequence)"html");
        XmlModel head = result.addElement("head");
        head.addElement("meta").setAttribute("charset", (Object)charset);
        head.addElement("title").addText(title);
        if (cssLinks != null) {
            for (CharSequence cssLink : cssLinks) {
                head.addElement("link").setAttribute("href", (Object)cssLink).setAttribute("rel", (Object)"stylesheet");
            }
        }
        return new Element((ApiElement)result);
    }

    @Nonnull
    public Element setId(@Nullable CharSequence value) {
        this.setAttribute("id", value);
        return this;
    }

    @Nonnull
    public Element setMethod(@Nullable Object value) {
        this.setAttribute("method", value);
        return this;
    }

    @Nonnull
    public Element setAction(@Nullable Object value) {
        this.setAttribute("action", value);
        return this;
    }

    @Nonnull
    public Element setType(@Nullable Object value) {
        this.setAttribute("type", value);
        return this;
    }

    @Nonnull
    public Element setName(@Nullable CharSequence value) {
        this.setAttribute("name", value);
        return this;
    }

    @Nonnull
    public Element setValue(@Nullable Object value) {
        this.setAttribute("value", value);
        return this;
    }

    @Nonnull
    public Element setFor(@Nullable CharSequence value) {
        this.setAttribute("value", value);
        return this;
    }

    @Nonnull
    public Element setRows(@Nullable int value) {
        this.setAttribute("rows", value);
        return this;
    }

    @Nonnull
    public Element setCols(@Nullable Object value) {
        this.setAttribute("cols", value);
        return this;
    }

    @Nonnull
    public Element setColSpan(@Nullable int value) {
        this.setAttribute("colspan", value);
        return this;
    }

    @Nonnull
    public Element setRowSpan(@Nullable int value) {
        this.setAttribute("cols", value);
        return this;
    }

    @Nonnull
    public Element setHref(@Nullable CharSequence value) {
        this.setAttribute("href", value);
        return this;
    }

    @Nonnull
    public String toString() {
        return this.internalElement.toString();
    }
}

