/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.ajax;

import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ujorm.tools.Assert;
import org.ujorm.tools.Check;
import org.ujorm.tools.web.Element;
import org.ujorm.tools.web.ao.HttpParameter;
import org.ujorm.tools.web.ao.Injector;

public class JavaScriptWriter
implements Injector {
    public static final HttpParameter DEFAULT_AJAX_REQUEST_PARAM = new HttpParameter(){

        @Override
        public String toString() {
            return "_ajax";
        }
    };
    public static final Duration DEFAULT_DURATION = Duration.ofMillis(250L);
    protected final HttpParameter ajaxRequestParam;
    protected final CharSequence[] inputCssSelectors;
    @Nonnull
    protected Duration idleDelay = DEFAULT_DURATION;
    protected String formSelector = "form";
    protected boolean onLoadSubmit = false;
    protected CharSequence newLine = "\n";
    @Nullable
    protected CharSequence subtitleSelector;
    @Nonnull
    protected CharSequence errorMessage = "AJAX fails due";
    @Nonnull
    protected Duration ajaxTimeout = Duration.ofMillis(30000L);

    public JavaScriptWriter() {
        this("form input");
    }

    public JavaScriptWriter(CharSequence ... inputSelectors) {
        this(DEFAULT_DURATION, DEFAULT_AJAX_REQUEST_PARAM, inputSelectors);
    }

    public JavaScriptWriter(@Nonnull Duration idleDelay, @Nonnull HttpParameter ajaxRequestParam, CharSequence ... inputSelectors) {
        this.idleDelay = (Duration)Assert.notNull((Object)idleDelay, (Object[])new String[]{"idleDelay"});
        this.ajaxRequestParam = (HttpParameter)Assert.notNull((Object)ajaxRequestParam, (Object[])new String[]{"ajaxRequestParam"});
        this.inputCssSelectors = (CharSequence[])Assert.hasLength((Object[])inputSelectors, (Object[])new String[]{"inputSelectors"});
    }

    public JavaScriptWriter setFormSelector(String formSelector) {
        this.formSelector = (String)Assert.notNull((Object)formSelector, (Object[])new String[]{"formSelector"});
        return this;
    }

    public JavaScriptWriter setOnLoadSubmit(boolean onLoadSubmit) {
        this.onLoadSubmit = onLoadSubmit;
        return this;
    }

    public JavaScriptWriter setNewLine(@Nonnull CharSequence newLine) {
        this.newLine = (CharSequence)Assert.notNull((Object)newLine, (Object[])new String[]{"newLine"});
        return this;
    }

    public JavaScriptWriter setSubtitleSelector(CharSequence subtitleSelector) {
        this.subtitleSelector = subtitleSelector;
        return this;
    }

    public JavaScriptWriter setErrorMessage(@Nullable CharSequence errorMessage) {
        this.errorMessage = Assert.hasLength((CharSequence)errorMessage, (Object[])new String[]{"errorMessage"});
        return this;
    }

    public JavaScriptWriter setAjaxTimeout(@Nonnull Duration ajaxTimeout) {
        this.ajaxTimeout = (Duration)Assert.notNull((Object)ajaxTimeout, (Object[])new String[]{"ajaxTimeout"});
        return this;
    }

    @Override
    public void write(@Nonnull Element parent) {
        try (Element js = parent.addElement("script");){
            js.addRawText((Object)this.newLine);
            js.addRawText((Object)"$(document).ready(function(){");
            if (Check.hasLength((Object[])this.inputCssSelectors)) {
                String inpSelectors = Stream.of(this.inputCssSelectors).collect(Collectors.joining(", "));
                js.addRawTexts(this.newLine, "", "var globalTimeout = null;", "$('" + inpSelectors + "').keyup(function() {", "  if (globalTimeout != null) {", "    clearTimeout(globalTimeout);", "  }", "  globalTimeout = setTimeout(function() {", "    globalTimeout = null;", "    $('" + this.formSelector + "').submit();", "  }, " + this.idleDelay.toMillis() + ");", "});");
            }
            js.addRawTexts(this.newLine, "", "$('form').submit(function(event){", "  var data = $('" + this.formSelector + "').serialize();", "  $.ajax({ url: '?" + this.ajaxRequestParam + "=true', type: 'POST', data: data, timeout: " + this.ajaxTimeout.toMillis() + ", error: function (xhr, ajaxOptions, thrownError) {", Check.hasLength((CharSequence)this.subtitleSelector) ? "   $('" + this.subtitleSelector + "').html('" + this.errorMessage + ": ' + thrownError);" : "", "  }, success: function(result){", "    var jsn = JSON.parse(result);", "    $.each(jsn, function(key, value){", "      $(key).html(value);", "    })", "  }});", "  event.preventDefault();", "});", this.onLoadSubmit ? "  $('" + this.formSelector + "').submit();" : "");
            js.addRawTexts(this.newLine, "", "});");
        }
    }
}

