/*
 * Decompiled with CFR 0.152.
 */
package org.ujorm.tools.web.json;

import java.io.Closeable;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ujorm.tools.web.HtmlElement;
import org.ujorm.tools.web.ao.ObjectProvider;
import org.ujorm.tools.web.json.JsonWriter;
import org.ujorm.tools.web.json.ValueProvider;
import org.ujorm.tools.xml.config.HtmlConfig;

public class JsonBuilder
implements Closeable {
    private static final char DOUBLE_QUOTE = '\"';
    @Nonnull
    private final Appendable writer;
    @Nonnull
    private final JsonWriter jsonWriter;
    private final HtmlConfig config;
    private int paramCounter = 0;

    protected JsonBuilder(@Nonnull Appendable writer) {
        this(writer, (HtmlConfig)HtmlConfig.ofEmptyElement());
    }

    protected JsonBuilder(@Nonnull Appendable writer, HtmlConfig config) {
        this.writer = writer;
        this.jsonWriter = new JsonWriter(writer);
        this.config = config;
    }

    public JsonBuilder writeId(@Nonnull CharSequence elementId, CharSequence ... values) throws IOException {
        this.write(SelectorType.ID.prefix, elementId, values);
        return this;
    }

    public JsonBuilder writeClass(@Nonnull CharSequence elementId, CharSequence ... values) throws IOException {
        this.write(SelectorType.CLASS.prefix, elementId, values);
        return this;
    }

    public JsonBuilder write(@Nonnull CharSequence key, CharSequence ... values) throws IOException {
        this.write(SelectorType.INCLUDED.prefix, key, values);
        return this;
    }

    public JsonBuilder write(@Nonnull String keyPrefix, @Nonnull CharSequence key, CharSequence ... values) throws IOException {
        this.writeKey(keyPrefix, key);
        if (values == null) {
            this.writer.append("null");
        } else {
            this.writer.append('\"');
            for (CharSequence value : values) {
                this.jsonWriter.append(value);
            }
        }
        this.writer.append('\"');
        return this;
    }

    private void writeKey(String keyPrefix, CharSequence key) throws IOException {
        this.writer.append(this.paramCounter++ == 0 ? (char)'{' : ',');
        this.writer.append('\"');
        this.jsonWriter.append(keyPrefix);
        this.jsonWriter.append(key);
        this.writer.append('\"');
        this.writer.append(':');
    }

    public JsonBuilder writeId(@Nonnull CharSequence elementId, @Nonnull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.ID.prefix, elementId, valueProvider);
    }

    public JsonBuilder writeClass(@Nonnull CharSequence elementId, @Nonnull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.CLASS.prefix, elementId, valueProvider);
    }

    public JsonBuilder write(@Nonnull CharSequence key, @Nonnull ValueProvider valueProvider) throws IOException {
        return this.write(SelectorType.INCLUDED.prefix, key, valueProvider);
    }

    public JsonBuilder write(@Nonnull String keyPrefix, @Nonnull CharSequence key, @Nonnull ValueProvider valueProvider) throws IOException {
        this.writeKey(keyPrefix, key);
        this.writer.append('\"');
        try (HtmlElement root = HtmlElement.of(this.config, this.jsonWriter);){
            valueProvider.accept(root.original());
        }
        this.writer.append('\"');
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.paramCounter == 0) {
            this.writer.append('{');
        }
        this.writer.append('}');
    }

    public JsonBuilder writeIdObj(@Nonnull CharSequence elementId, @Nonnull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.ID.prefix, elementId, objectProvider);
    }

    public JsonBuilder writeClassObj(@Nonnull CharSequence elementId, @Nonnull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.CLASS.prefix, elementId, objectProvider);
    }

    public JsonBuilder writeObj(@Nonnull CharSequence key, @Nonnull ObjectProvider objectProvider) throws IOException {
        return this.writeObj(SelectorType.INCLUDED.prefix, key, objectProvider);
    }

    public JsonBuilder writeObj(@Nonnull String keyPrefix, @Nonnull CharSequence key, @Nonnull ObjectProvider objectProvider) throws IOException {
        this.writeKey(keyPrefix, key);
        objectProvider.accept(this);
        this.writer.append('\"');
        return this;
    }

    @Nonnull
    public static final JsonBuilder of(@Nonnull Appendable writer) {
        return new JsonBuilder(writer);
    }

    @Nonnull
    public static final JsonBuilder of(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IllegalStateException, IOException {
        return JsonBuilder.of(request, response, (HtmlConfig)HtmlConfig.ofDefault());
    }

    @Nonnull
    public static final JsonBuilder of(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull HtmlConfig config) throws IllegalStateException, IOException {
        if (config.isHtmlHeaderRequest()) {
            response.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            response.addHeader("Pragma", "no-cache");
            response.addHeader("Expires", "0");
        }
        String charset = config.getCharset().toString();
        request.setCharacterEncoding(charset);
        response.setCharacterEncoding(charset);
        return JsonBuilder.of(response.getWriter());
    }

    public static enum SelectorType {
        ID("#"),
        CLASS("."),
        INCLUDED("");

        final String prefix;

        private SelectorType(String prefix) {
            this.prefix = prefix;
        }

        @Nonnull
        public String getPrefix() {
            return this.prefix;
        }
    }
}

